/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundableProcessIndicator
extends ProgressWindow {
    protected StatusBarEx myStatusBar;
    private PerformInBackgroundOption myOption;
    private TaskInfo myInfo;
    private boolean myDisposed;
    private DumbModeAction myDumbModeAction;

    public BackgroundableProcessIndicator(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(0);
        }
        this(task2.getProject(), (TaskInfo)task2, (PerformInBackgroundOption)task2);
        this.myDumbModeAction = task2.getDumbModeAction();
        if (this.myDumbModeAction == DumbModeAction.CANCEL) {
            task2.getProject().getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    BackgroundableProcessIndicator.this.cancel();
                }

                public void exitDumbMode() {
                }
            });
        }
    }

    public BackgroundableProcessIndicator(final @Nullable Project project, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option) {
        if (info == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(1);
        }
        if (option == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(2);
        }
        super(info.isCancellable(), true, project, info.getCancelText());
        this.myDumbModeAction = DumbModeAction.NOTHING;
        if (project != null) {
            project.getMessageBus().connect((Disposable)this).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosing(Project eventProject) {
                    if (eventProject == project && BackgroundableProcessIndicator.this.isRunning()) {
                        BackgroundableProcessIndicator.this.cancel();
                    }
                }
            });
        }
        this.setOwnerTask(info);
        this.setProcessId(info.getProcessId());
        this.myOption = option;
        this.myInfo = info;
        this.setTitle(info.getTitle());
        Project nonDefaultProject = project == null || project.isDisposed() ? null : (project.isDefault() ? null : project);
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(nonDefaultProject);
        this.myStatusBar = frame != null ? (StatusBarEx)frame.getStatusBar() : null;
        this.myBackgrounded = this.shouldStartInBackground();
        if (this.myBackgrounded) {
            this.doBackground();
        }
    }

    private boolean shouldStartInBackground() {
        return this.myOption.shouldStartInBackground() && this.myStatusBar != null;
    }

    public BackgroundableProcessIndicator(Project project, final @Nls String progressTitle, @NotNull PerformInBackgroundOption option, final @Nls String cancelButtonText, final @Nls String backgroundStopTooltip, final boolean cancellable) {
        if (option == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(3);
        }
        this(project, new TaskInfo(){

            public String getProcessId() {
                return "<unknown>";
            }

            @NotNull
            public String getTitle() {
                String string = progressTitle;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String getCancelText() {
                return cancelButtonText;
            }

            public String getCancelTooltipText() {
                return backgroundStopTooltip;
            }

            public boolean isCancellable() {
                return cancellable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator$3", "getTitle"));
            }
        }, option);
    }

    @Deprecated
    public DumbModeAction getDumbModeAction() {
        return this.myDumbModeAction;
    }

    @Override
    protected void showDialog() {
        if (this.myDisposed) {
            return;
        }
        if (this.shouldStartInBackground()) {
            return;
        }
        super.showDialog();
    }

    @Override
    public void background() {
        if (this.myDisposed) {
            return;
        }
        this.myOption.processSentToBackground();
        this.doBackground();
        super.background();
    }

    private void doBackground() {
        if (this.myStatusBar != null) {
            this.myStatusBar.addProgress(this, this.myInfo);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myDisposed = true;
        this.myInfo = null;
        this.myStatusBar = null;
        this.myOption = null;
    }

    @Override
    public boolean isShowing() {
        return this.isModal() || !this.isBackgrounded();
    }

    @Override
    public String toString() {
        return super.toString() + "; task=" + this.myInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "task";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "option";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

