/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import java.io.File;
import javax.swing.SwingUtilities;

public abstract class AbstractCommand
implements PlaybackCommand {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractCommand.class.getPackage().getName()));
    public static final String CMD_PREFIX = "%";
    private final String myText;
    private final int myLine;
    private final boolean myExecuteInAwt;
    private File myScriptDir;

    public AbstractCommand(String text, int line) {
        this(text, line, false);
    }

    public AbstractCommand(String text, int line, boolean executeInAwt) {
        this.myExecuteInAwt = executeInAwt;
        this.myText = text != null ? text : null;
        this.myLine = line;
    }

    public String getText() {
        return this.myText;
    }

    public int getLine() {
        return this.myLine;
    }

    @Override
    public boolean canGoFurther() {
        return true;
    }

    @Override
    public final ActionCallback execute(PlaybackContext context) {
        try {
            if (this.isToDumpCommand()) {
                this.dumpCommand(context);
            }
            ActionCallback result2 = new ActionCallback();
            Runnable runnable2 = () -> {
                try {
                    this._execute(context).notify(result2);
                }
                catch (Throwable e) {
                    LOG.error(e);
                    context.error(e.getMessage(), this.getLine());
                    result2.setRejected();
                }
            };
            if (this.isAwtThread()) {
                SwingUtilities.invokeLater(runnable2);
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(runnable2);
            }
            return result2;
        }
        catch (Throwable e) {
            context.error(e.getMessage(), this.getLine());
            return ActionCallback.REJECTED;
        }
    }

    protected boolean isToDumpCommand() {
        return true;
    }

    protected boolean isAwtThread() {
        return this.myExecuteInAwt;
    }

    protected abstract ActionCallback _execute(PlaybackContext var1);

    public void dumpCommand(PlaybackContext context) {
        context.code(this.getText(), this.getLine());
    }

    public void dumpError(PlaybackContext context, String text) {
        context.error(text, this.getLine());
    }

    @Override
    public File getScriptDir() {
        return this.myScriptDir;
    }

    public PlaybackCommand setScriptDir(File scriptDir) {
        this.myScriptDir = scriptDir;
        return this;
    }
}

