/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.util;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;

public class ProjectPlaybackCall {
    public static AsyncResult<String> openProjectClone(PlaybackContext context, String path) {
        try {
            File parentDir = FileUtil.createTempDirectory((String)"funcTest", (String)"");
            File sourceDir = context.getPathMacro().resolveFile(path, context.getBaseDir());
            context.message("Cloning project: " + sourceDir.getAbsolutePath(), context.getCurrentLine());
            FileUtil.copyDir((File)sourceDir, (File)parentDir);
            File projectDir = new File(parentDir, sourceDir.getName());
            return ProjectPlaybackCall.openProject(context, projectDir.getAbsolutePath());
        }
        catch (IOException e) {
            return AsyncResult.rejected((String)"Cannot create temp directory for clone");
        }
    }

    public static AsyncResult<String> openLastProject(PlaybackContext context) {
        return ProjectPlaybackCall.openProject(context, RecentProjectsManager.getInstance().getLastProjectPath());
    }

    public static AsyncResult<String> openProject(PlaybackContext context, String path) {
        AsyncResult result2 = new AsyncResult();
        ProjectUtil.runWhenProjectOpened(project -> StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> DumbService.getInstance((Project)project).runWhenSmart(() -> result2.setDone((Object)("Opened successfully: " + project.getPresentableUrl())))));
        UIUtil.invokeLaterIfNeeded(() -> {
            try {
                ProjectManager.getInstance().loadAndOpenProject(path);
            }
            catch (Exception e) {
                context.error(e.getMessage(), context.getCurrentLine());
                result2.setRejected();
            }
        });
        return result2;
    }
}

