/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeViewDiffRequestProcessor
extends CacheDiffRequestProcessor<DiffRequestProducer>
implements DiffPreviewUpdateProcessor {
    @Nullable
    private Wrapper myCurrentChange;

    public ChangeViewDiffRequestProcessor(@NotNull Project project, @NotNull String place) {
        if (project == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(1);
        }
        super(project, place);
    }

    @NotNull
    protected abstract List<Wrapper> getSelectedChanges();

    @NotNull
    protected abstract List<Wrapper> getAllChanges();

    protected abstract void selectChange(@NotNull Wrapper var1);

    @Override
    @NotNull
    protected String getRequestName(@NotNull DiffRequestProducer producer) {
        if (producer == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        String string = producer.getName();
        if (string == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected DiffRequestProducer getCurrentRequestProvider() {
        return this.myCurrentChange != null ? this.myCurrentChange.createProducer(this.getProject()) : null;
    }

    @Override
    @NotNull
    protected DiffRequest loadRequest(@NotNull DiffRequestProducer producer, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
        if (producer == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(5);
        }
        DiffRequest diffRequest = producer.process((UserDataHolder)this.getContext(), indicator);
        if (diffRequest == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(6);
        }
        return diffRequest;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = super.getProject();
        if (project == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(7);
        }
        return project;
    }

    @Override
    public void clear() {
        this.myCurrentChange = null;
        this.updateRequest();
    }

    @Override
    public void refresh() {
        Wrapper selectedChange;
        List<Wrapper> selectedChanges = this.getSelectedChanges();
        if (selectedChanges.isEmpty()) {
            this.myCurrentChange = null;
            this.updateRequest();
            return;
        }
        Wrapper wrapper2 = selectedChange = this.myCurrentChange != null ? (Wrapper)ContainerUtil.find(selectedChanges, (Object)this.myCurrentChange) : null;
        if (selectedChange == null) {
            if (this.myCurrentChange != null && this.isFocused()) {
                if (selectedChanges.size() == 1 && this.getAllChanges().contains(this.myCurrentChange)) {
                    this.selectChange(this.myCurrentChange);
                }
                return;
            }
            this.myCurrentChange = selectedChanges.get(0);
            this.updateRequest();
            return;
        }
        this.myCurrentChange = selectedChange;
        this.updateRequest();
    }

    @Override
    protected boolean hasNextChange() {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy();
        return strategy != null && strategy.canGoNext();
    }

    @Override
    protected boolean hasPrevChange() {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy();
        return strategy != null && strategy.canGoPrev();
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        ((PrevNextDifferenceIterable)ObjectUtils.notNull((Object)this.getSelectionStrategy())).goNext();
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        ((PrevNextDifferenceIterable)ObjectUtils.notNull((Object)this.getSelectionStrategy())).goPrev();
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return true;
    }

    @Nullable
    private PrevNextDifferenceIterable getSelectionStrategy() {
        if (this.myCurrentChange == null) {
            return null;
        }
        List<Wrapper> selectedChanges = this.getSelectedChanges();
        if (selectedChanges.isEmpty()) {
            return null;
        }
        if (selectedChanges.size() == 1) {
            return new ChangesNavigatable(this.getAllChanges(), selectedChanges.get(0), true);
        }
        return new ChangesNavigatable(selectedChanges, selectedChanges.get(0), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRequest";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRequestName";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ErrorChangeRequestProducer
    implements DiffRequestProducer {
        @NotNull
        private final Change myChange;
        @NotNull
        private final DiffRequest myRequest;

        public ErrorChangeRequestProducer(@NotNull Change change, @NotNull DiffRequest request) {
            if (change == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(0);
            }
            if (request == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(1);
            }
            this.myChange = change;
            this.myRequest = request;
        }

        @NotNull
        public String getName() {
            String string = ChangeDiffRequestProducer.getRequestTitle(this.myChange);
            if (string == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
            if (context == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(4);
            }
            DiffRequest diffRequest = this.myRequest;
            if (diffRequest == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ErrorChangeRequestProducer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ErrorChangeRequestProducer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class UnversionedFileWrapper
    extends Wrapper {
        @NotNull
        private final VirtualFile file;

        public UnversionedFileWrapper(@NotNull VirtualFile file2) {
            if (file2 == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(0);
            }
            this.file = file2;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            return UnversionedDiffRequestProducer.create(project, this.file);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            UnversionedFileWrapper wrapper2 = (UnversionedFileWrapper)o;
            return wrapper2.file.equals(this.file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$UnversionedFileWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$UnversionedFileWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class ChangeWrapper
    extends Wrapper {
        @NotNull
        private final Change change;

        public ChangeWrapper(@NotNull Change change) {
            if (change == null) {
                ChangeWrapper.$$$reportNull$$$0(0);
            }
            this.change = change;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            Change change = this.change;
            if (change == null) {
                ChangeWrapper.$$$reportNull$$$0(1);
            }
            return change;
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            if (this.change.getBeforeRevision() instanceof FakeRevision || this.change.getAfterRevision() instanceof FakeRevision) {
                LoadingDiffRequest request = new LoadingDiffRequest(ChangeDiffRequestProducer.getRequestTitle(this.change));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            ChangeDiffRequestProducer producer = ChangeDiffRequestProducer.create(project, this.change);
            if (producer == null) {
                ErrorDiffRequest request = new ErrorDiffRequest(DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0]));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            return producer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            ChangeWrapper wrapper2 = (ChangeWrapper)o;
            return wrapper2.change.equals((Object)this.change);
        }

        public int hashCode() {
            return this.change.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ChangeWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ChangeWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class Wrapper {
        protected Wrapper() {
        }

        @NotNull
        public abstract Object getUserObject();

        @Nullable
        public abstract DiffRequestProducer createProducer(@Nullable Project var1);
    }

    private class ChangesNavigatable
    implements PrevNextDifferenceIterable {
        @NotNull
        private final List<Wrapper> myChanges;
        @NotNull
        private final Wrapper myFallback;
        private final boolean myUpdateSelection;

        public ChangesNavigatable(@NotNull List<Wrapper> allChanges, Wrapper fallback, boolean updateSelection) {
            if (allChanges == null) {
                ChangesNavigatable.$$$reportNull$$$0(0);
            }
            if (fallback == null) {
                ChangesNavigatable.$$$reportNull$$$0(1);
            }
            this.myChanges = allChanges;
            this.myFallback = fallback;
            this.myUpdateSelection = updateSelection;
        }

        @Override
        public boolean canGoNext() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index == -1 || index < this.myChanges.size() - 1;
        }

        @Override
        public boolean canGoPrev() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index == -1 || index > 0;
        }

        @Override
        public void goNext() {
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index != -1) {
                this.select(this.myChanges.get(index + 1));
            } else {
                this.select(this.myFallback);
            }
        }

        @Override
        public void goPrev() {
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index != -1) {
                this.select(this.myChanges.get(index - 1));
            } else {
                this.select(this.myFallback);
            }
        }

        private void select(@NotNull Wrapper change) {
            if (change == null) {
                ChangesNavigatable.$$$reportNull$$$0(2);
            }
            ChangeViewDiffRequestProcessor.this.myCurrentChange = change;
            if (this.myUpdateSelection) {
                ChangeViewDiffRequestProcessor.this.selectChange(change);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allChanges";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fallback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ChangesNavigatable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

