/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.Nullable;

public class SetDefault
implements ChangeListCommand {
    private final String myNewDefaultName;
    private String myPrevious;
    private LocalChangeList myOldDefaultListCopy;
    private LocalChangeList myNewDefaultListCopy;

    public SetDefault(@Nullable String newDefaultName) {
        this.myNewDefaultName = newDefaultName;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        LocalChangeList list2 = worker.getChangeListByName(this.myNewDefaultName);
        if (list2 == null || list2.isDefault()) {
            this.myOldDefaultListCopy = null;
            this.myPrevious = null;
            this.myNewDefaultListCopy = null;
            return;
        }
        this.myOldDefaultListCopy = worker.getDefaultList().copy();
        this.myPrevious = worker.setDefault(this.myNewDefaultName);
        this.myNewDefaultListCopy = worker.getDefaultList().copy();
    }

    @Override
    public void doNotify(EventDispatcher<ChangeListListener> dispatcher) {
        if (this.myPrevious != null) {
            ((ChangeListListener)dispatcher.getMulticaster()).defaultListChanged((ChangeList)this.myOldDefaultListCopy, (ChangeList)this.myNewDefaultListCopy);
        }
    }

    @Nullable
    public String getPrevious() {
        return this.myPrevious;
    }
}

