/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.patch.AutoMatchStrategy;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

class OneBaseStrategy
extends AutoMatchStrategy {
    private boolean mySucceeded = true;
    private final MultiMap<VirtualFile, TextFilePatchInProgress> myVariants = new MultiMap();
    private boolean myCheckExistingVariants = false;

    OneBaseStrategy(VirtualFile baseDir) {
        super(baseDir);
    }

    @Override
    public void acceptPatch(TextFilePatch patch, Collection<VirtualFile> foundByName) {
        if (!this.mySucceeded) {
            return;
        }
        if (foundByName.isEmpty()) {
            this.mySucceeded = false;
            return;
        }
        LinkedList<TextFilePatchInProgress> results = new LinkedList<TextFilePatchInProgress>();
        HashSet keysToRemove = new HashSet(this.myVariants.keySet());
        for (VirtualFile file2 : foundByName) {
            TextFilePatchInProgress textFilePatchInProgress = this.processMatch(patch, file2);
            if (textFilePatchInProgress == null) continue;
            VirtualFile base = textFilePatchInProgress.getBase();
            if (this.myCheckExistingVariants && !this.myVariants.containsKey((Object)base)) continue;
            keysToRemove.remove(base);
            results.add(textFilePatchInProgress);
        }
        if (this.myCheckExistingVariants) {
            for (VirtualFile file2 : keysToRemove) {
                this.myVariants.remove((Object)file2);
            }
            if (this.myVariants.isEmpty()) {
                this.mySucceeded = false;
                return;
            }
        }
        Collection<VirtualFile> exactMatch = this.filterVariants(patch, foundByName);
        for (TextFilePatchInProgress textFilePatchInProgress : results) {
            textFilePatchInProgress.setAutoBases(exactMatch);
            this.myVariants.putValue((Object)textFilePatchInProgress.getBase(), (Object)textFilePatchInProgress);
        }
        this.myCheckExistingVariants = true;
    }

    @Override
    public void processCreation(TextFilePatch creation) {
        if (!this.mySucceeded) {
            return;
        }
        TextFilePatchInProgress textFilePatchInProgress = this.myVariants.isEmpty() ? new TextFilePatchInProgress(creation, null, this.myBaseDir) : new TextFilePatchInProgress(creation, null, (VirtualFile)this.myVariants.keySet().iterator().next());
        this.myResult.add(textFilePatchInProgress);
    }

    @Override
    public boolean succeeded() {
        return this.mySucceeded;
    }

    @Override
    public void beforeCreations() {
        if (!this.mySucceeded) {
            return;
        }
        if (this.myVariants.size() > 1) {
            Pair privilegedSurvivor = null;
            for (VirtualFile file2 : this.myVariants.keySet()) {
                Collection patches = this.myVariants.get((Object)file2);
                int numStrip = -1;
                boolean sameStrip = true;
                for (TextFilePatchInProgress patch : patches) {
                    if (numStrip == -1) {
                        numStrip = patch.getCurrentStrip();
                        continue;
                    }
                    if (numStrip == patch.getCurrentStrip()) continue;
                    sameStrip = false;
                    break;
                }
                if (!sameStrip) continue;
                privilegedSurvivor = Pair.create((Object)file2, (Object)patches);
                break;
            }
            if (privilegedSurvivor == null) {
                VirtualFile first = (VirtualFile)this.myVariants.keySet().iterator().next();
                privilegedSurvivor = Pair.create((Object)first, (Object)this.myVariants.get((Object)first));
            }
            this.myVariants.clear();
            this.myVariants.put(privilegedSurvivor.getFirst(), (Collection)privilegedSurvivor.getSecond());
        }
        this.myResult.addAll(this.myVariants.values());
    }
}

