/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchChangeBuilder {
    @NotNull
    private final StringBuilder myBuilder = new StringBuilder();
    @NotNull
    private final List<Hunk> myHunks = new ArrayList<Hunk>();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor1 = new LineNumberConvertor.Builder();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor2 = new LineNumberConvertor.Builder();
    @NotNull
    private final TIntArrayList myChangedLines = new TIntArrayList();
    private int totalLines = 0;

    PatchChangeBuilder() {
    }

    public void exec(@NotNull List<AppliedTextPatch.AppliedSplitPatchHunk> splitHunks) {
        if (splitHunks == null) {
            PatchChangeBuilder.$$$reportNull$$$0(0);
        }
        int lastBeforeLine = -1;
        for (AppliedTextPatch.AppliedSplitPatchHunk hunk : splitHunks) {
            List<String> contextBefore = hunk.getContextBefore();
            List<String> contextAfter = hunk.getContextAfter();
            LineRange beforeRange = hunk.getLineRangeBefore();
            LineRange afterRange = hunk.getLineRangeAfter();
            int overlappedContext = 0;
            if (lastBeforeLine != -1) {
                if (lastBeforeLine >= beforeRange.start) {
                    overlappedContext = lastBeforeLine - beforeRange.start + 1;
                } else if (lastBeforeLine < beforeRange.start - 1) {
                    this.appendSeparator();
                }
            }
            List<String> trimContext = contextBefore.subList(overlappedContext, contextBefore.size());
            this.addContext(trimContext, beforeRange.start + overlappedContext, afterRange.start + overlappedContext);
            int deletion = this.totalLines;
            this.appendLines(hunk.getDeletedLines());
            int insertion = this.totalLines;
            this.appendLines(hunk.getInsertedLines());
            int hunkEnd = this.totalLines;
            this.myConvertor1.put(deletion, beforeRange.start + contextBefore.size(), insertion - deletion);
            this.myConvertor2.put(insertion, afterRange.start + contextBefore.size(), hunkEnd - insertion);
            this.addContext(contextAfter, beforeRange.end - contextAfter.size(), afterRange.end - contextAfter.size());
            lastBeforeLine = beforeRange.end - 1;
            LineRange deletionRange = new LineRange(deletion, insertion);
            LineRange insertionRange = new LineRange(insertion, hunkEnd);
            this.myHunks.add(new Hunk(hunk.getInsertedLines(), deletionRange, insertionRange, hunk.getAppliedTo(), hunk.getStatus()));
        }
    }

    private void addContext(@NotNull List<String> context, int beforeLineNumber, int afterLineNumber) {
        if (context == null) {
            PatchChangeBuilder.$$$reportNull$$$0(1);
        }
        this.myConvertor1.put(this.totalLines, beforeLineNumber, context.size());
        this.myConvertor2.put(this.totalLines, afterLineNumber, context.size());
        this.appendLines(context);
    }

    private void appendLines(@NotNull List<String> lines2) {
        if (lines2 == null) {
            PatchChangeBuilder.$$$reportNull$$$0(2);
        }
        for (String line : lines2) {
            this.myBuilder.append(line).append("\n");
        }
        this.totalLines += lines2.size();
    }

    private void appendSeparator() {
        this.myChangedLines.add(this.totalLines);
        this.myBuilder.append("\n");
        ++this.totalLines;
    }

    @NotNull
    public CharSequence getPatchContent() {
        StringBuilder stringBuilder = this.myBuilder;
        if (stringBuilder == null) {
            PatchChangeBuilder.$$$reportNull$$$0(3);
        }
        return stringBuilder;
    }

    @NotNull
    public List<Hunk> getHunks() {
        List<Hunk> list2 = this.myHunks;
        if (list2 == null) {
            PatchChangeBuilder.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public LineNumberConvertor getLineConvertor1() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor1.build();
        if (lineNumberConvertor == null) {
            PatchChangeBuilder.$$$reportNull$$$0(5);
        }
        return lineNumberConvertor;
    }

    @NotNull
    public LineNumberConvertor getLineConvertor2() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor2.build();
        if (lineNumberConvertor == null) {
            PatchChangeBuilder.$$$reportNull$$$0(6);
        }
        return lineNumberConvertor;
    }

    @NotNull
    public TIntArrayList getSeparatorLines() {
        TIntArrayList tIntArrayList = this.myChangedLines;
        if (tIntArrayList == null) {
            PatchChangeBuilder.$$$reportNull$$$0(7);
        }
        return tIntArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitHunks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchContent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHunks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineConvertor1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineConvertor2";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendLines";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Hunk {
        @NotNull
        private final List<String> myInsertedLines;
        @NotNull
        private final LineRange myPatchDeletionRange;
        @NotNull
        private final LineRange myPatchInsertionRange;
        @Nullable
        private final LineRange myAppliedToLines;
        @NotNull
        private final AppliedTextPatch.HunkStatus myStatus;

        public Hunk(@NotNull List<String> insertedLines, @NotNull LineRange patchDeletionRange, @NotNull LineRange patchInsertionRange, @Nullable LineRange appliedToLines, @NotNull AppliedTextPatch.HunkStatus status) {
            if (insertedLines == null) {
                Hunk.$$$reportNull$$$0(0);
            }
            if (patchDeletionRange == null) {
                Hunk.$$$reportNull$$$0(1);
            }
            if (patchInsertionRange == null) {
                Hunk.$$$reportNull$$$0(2);
            }
            if (status == null) {
                Hunk.$$$reportNull$$$0(3);
            }
            this.myInsertedLines = insertedLines;
            this.myPatchDeletionRange = patchDeletionRange;
            this.myPatchInsertionRange = patchInsertionRange;
            this.myAppliedToLines = appliedToLines;
            this.myStatus = status;
        }

        @NotNull
        public LineRange getPatchDeletionRange() {
            LineRange lineRange = this.myPatchDeletionRange;
            if (lineRange == null) {
                Hunk.$$$reportNull$$$0(4);
            }
            return lineRange;
        }

        @NotNull
        public LineRange getPatchInsertionRange() {
            LineRange lineRange = this.myPatchInsertionRange;
            if (lineRange == null) {
                Hunk.$$$reportNull$$$0(5);
            }
            return lineRange;
        }

        @NotNull
        public AppliedTextPatch.HunkStatus getStatus() {
            AppliedTextPatch.HunkStatus hunkStatus = this.myStatus;
            if (hunkStatus == null) {
                Hunk.$$$reportNull$$$0(6);
            }
            return hunkStatus;
        }

        @Nullable
        public LineRange getAppliedToLines() {
            return this.myAppliedToLines;
        }

        @NotNull
        private List<String> getInsertedLines() {
            List<String> list2 = this.myInsertedLines;
            if (list2 == null) {
                Hunk.$$$reportNull$$$0(7);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertedLines";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchDeletionRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchInsertionRange";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatchDeletionRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatchInsertionRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertedLines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

