/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DummyCachingFileSystem<T extends VirtualFile>
extends DummyFileSystem {
    private final String myProtocol;
    private final ConcurrentMap<String, T> myCachedFiles = ConcurrentFactoryMap.createMap(this::findFileByPathInner);
    private static final Key<Boolean> DISPOSE_CALLBACK = Key.create((String)"DISPOSE_CALLBACK");

    public DummyCachingFileSystem(String protocol) {
        this.myProtocol = protocol;
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect((Disposable)application).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project) {
                DummyCachingFileSystem.this.onProjectOpened(project);
            }

            public void projectClosed(Project project) {
                DummyCachingFileSystem.this.registerDisposeCallback(project);
            }
        });
        this.initProjectMap();
    }

    @Override
    @NotNull
    public final String getProtocol() {
        String string = this.myProtocol;
        if (string == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public final VirtualFile createRoot(String name) {
        return null;
    }

    public final T findFileByPath(@NotNull String path) {
        VirtualFile file2;
        if (path == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(1);
        }
        if ((file2 = (VirtualFile)this.myCachedFiles.get(path)) != null && !file2.isValid()) {
            this.myCachedFiles.remove(path);
            file2 = (VirtualFile)this.myCachedFiles.get(path);
        }
        return (T)file2;
    }

    @Override
    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        T file2;
        if (path == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(2);
        }
        String string = (file2 = this.findFileByPath(path)) != null ? this.getPresentableUrl((VirtualFile)file2) : super.extractPresentableUrl(path);
        if (string == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected String getPresentableUrl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(4);
        }
        return file2.getPresentableName();
    }

    protected abstract T findFileByPathInner(@NotNull String var1);

    protected void doRenameFile(VirtualFile vFile, String newName) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Nullable
    public Project getProject(@Nullable String projectId) {
        Project project = ((ProjectManagerImpl)ProjectManager.getInstance()).findOpenProjectByHash(projectId);
        if (ApplicationManager.getApplication().isUnitTestMode() && project != null) {
            this.registerDisposeCallback(project);
            DISPOSE_CALLBACK.set((UserDataHolder)project, (Object)Boolean.TRUE);
        }
        return project;
    }

    @NotNull
    public Project getProjectOrFail(String projectId) {
        Project project = this.getProject(projectId);
        if (project == null) {
            throw new AssertionError((Object)String.format("'%s' project not found among %s", projectId, StringUtil.join((Object[])ProjectManager.getInstance().getOpenProjects(), p -> p.getLocationHash(), (String)", ")));
        }
        Project project2 = project;
        if (project2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(5);
        }
        return project2;
    }

    @NotNull
    public Collection<T> getCachedFiles() {
        Collection collection = this.myCachedFiles.values().stream().filter(Objects::nonNull).filter(VirtualFile::isValid).collect(Collectors.toList());
        if (collection == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public void onProjectClosed() {
        this.clearCache();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.cleanup();
        }
    }

    public void onProjectOpened(Project project) {
        this.clearCache();
    }

    private void registerDisposeCallback(Project project) {
        if (Boolean.TRUE.equals(DISPOSE_CALLBACK.get((UserDataHolder)project))) {
            return;
        }
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                DummyCachingFileSystem.this.onProjectClosed();
            }
        });
    }

    private void initProjectMap() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!project.isOpen()) continue;
            this.onProjectOpened(project);
        }
    }

    protected void clearCache() {
        this.clearInvalidFiles();
    }

    protected void clearInvalidFiles() {
        for (Map.Entry entry : this.myCachedFiles.entrySet()) {
            VirtualFile t = (VirtualFile)entry.getValue();
            if (t != null && t.isValid()) continue;
            this.myCachedFiles.remove(entry.getKey());
        }
    }

    private void cleanup() {
        this.myCachedFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(7);
        }
        if (newName == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(8);
        }
        String oldName = vFile.getName();
        this.beforeFileRename(vFile, requestor, oldName, newName);
        try {
            this.doRenameFile(vFile, newName);
        }
        finally {
            this.fileRenamed(vFile, requestor, oldName, newName);
        }
    }

    protected void beforeFileRename(@NotNull VirtualFile file2, Object requestor, @NotNull String oldName, @NotNull String newName) {
        if (file2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(9);
        }
        if (oldName == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(10);
        }
        if (newName == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(11);
        }
        this.fireBeforePropertyChange(requestor, file2, "name", oldName, newName);
        this.myCachedFiles.remove(file2.getPath());
    }

    protected void fileRenamed(@NotNull VirtualFile file2, Object requestor, String oldName, String newName) {
        if (file2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(12);
        }
        this.myCachedFiles.put(file2.getPath(), file2);
        this.firePropertyChanged(requestor, file2, "name", oldName, newName);
    }

    protected static String escapeSlash(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String)"/", (String)"&slash;");
    }

    protected static String unescapeSlash(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String)"&slash;", (String)"/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOrFail";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableUrl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeFileRename";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fileRenamed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

