/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeListsScopesProvider
extends CustomScopesProviderEx {
    @NotNull
    private final Project myProject;

    public static ChangeListsScopesProvider getInstance(Project project) {
        return (ChangeListsScopesProvider)((Object)Extensions.findExtension((ExtensionPointName)CUSTOM_SCOPES_PROVIDER, (AreaInstance)project, ChangeListsScopesProvider.class));
    }

    public ChangeListsScopesProvider(@NotNull Project project) {
        if (project == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<NamedScope> getCustomScopes() {
        if (this.myProject.isDefault() || !ProjectLevelVcsManager.getInstance((Project)this.myProject).hasAnyMappings()) {
            List<NamedScope> list2 = Collections.emptyList();
            if (list2 == null) {
                ChangeListsScopesProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        ArrayList<NamedScope> result2 = new ArrayList<NamedScope>();
        result2.add(ChangeListsScopesProvider.createScope(changeListManager.getAffectedFiles(), IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0])));
        for (ChangeList list3 : changeListManager.getChangeListsCopy()) {
            result2.add(ChangeListsScopesProvider.createChangeListScope(list3));
        }
        ArrayList<NamedScope> arrayList = result2;
        if (arrayList == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static NamedScope createChangeListScope(@NotNull ChangeList list2) {
        if (list2 == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(3);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        Collection changes = list2.getChanges();
        for (Change change : changes) {
            VirtualFile vFile;
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null || (vFile = afterRevision.getFile().getVirtualFile()) == null) continue;
            files.add(vFile);
        }
        return ChangeListsScopesProvider.createScope(files, list2.getName());
    }

    public NamedScope getCustomScope(@NotNull String name) {
        if (name == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDefault()) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        if (IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0]).equals(name)) {
            return ChangeListsScopesProvider.createScope(changeListManager.getAffectedFiles(), IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0]));
        }
        LocalChangeList changeList = changeListManager.findChangeList(name);
        if (changeList != null) {
            return ChangeListsScopesProvider.createChangeListScope((ChangeList)changeList);
        }
        return null;
    }

    public boolean isVetoed(NamedScope scope, CustomScopesProviderEx.ScopePlace place) {
        if (place == CustomScopesProviderEx.ScopePlace.SETTING) {
            if (this.myProject.isDefault()) {
                return false;
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            return changeListManager.findChangeList(scope.getName()) != null;
        }
        return false;
    }

    @NotNull
    private static NamedScope createScope(final @NotNull List<VirtualFile> files, @NotNull String changeListName) {
        if (files == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(5);
        }
        if (changeListName == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(6);
        }
        NamedScope namedScope = new NamedScope(changeListName, (PackageSet)new PackageSetBase(){

            public boolean contains(VirtualFile file2, NamedScopesHolder holder) {
                return files.contains(file2);
            }

            @NotNull
            public PackageSet createCopy() {
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return v0;
            }

            @NotNull
            public String getText() {
                if ("file:*//*" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "file:*//*";
            }

            public int getNodePriority() {
                return 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/packageDependencies/ChangeListsScopesProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCopy";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }){

            public boolean equals(Object obj) {
                if (!(obj instanceof NamedScope)) {
                    return false;
                }
                return this.getName().equals(((NamedScope)obj).getName());
            }

            public int hashCode() {
                return this.getName().hashCode();
            }
        };
        if (namedScope == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(7);
        }
        return namedScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/ChangeListsScopesProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/ChangeListsScopesProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomScopes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createChangeListScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCustomScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

