/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.InternalModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.PlatformUtils;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PredefinedSearchScopeProviderImpl
extends PredefinedSearchScopeProvider {
    @Override
    @NotNull
    public List<SearchScope> getPredefinedScopes(@NotNull Project project, @Nullable DataContext dataContext, boolean suggestSearchInLibs, boolean prevSearchFiles, boolean currentSelection, boolean usageView, boolean showEmptyScopes) {
        FavoritesManager favoritesManager;
        PsiElement parent;
        int end;
        PsiElement endElement;
        int start;
        PsiElement startElement;
        SelectionModel selectionModel;
        PsiFile psiFile;
        if (project == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(0);
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        result2.add(GlobalSearchScope.everythingScope((Project)project));
        result2.add(GlobalSearchScope.projectScope((Project)project));
        if (suggestSearchInLibs) {
            result2.add(GlobalSearchScope.allScope((Project)project));
        }
        if (ModuleUtil.isSupportedRootType((Project)project, (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE)) {
            result2.add(GlobalSearchScopesCore.projectProductionScope((Project)project));
            result2.add(GlobalSearchScopesCore.projectTestScope((Project)project));
        }
        result2.add(ScratchesSearchScope.getScratchesScope(project));
        GlobalSearchScope openFilesScope = GlobalSearchScopes.openFilesScope((Project)project);
        if (openFilesScope != GlobalSearchScope.EMPTY_SCOPE) {
            result2.add(openFilesScope);
        } else if (showEmptyScopes) {
            result2.add(new LocalSearchScope(PsiElement.EMPTY_ARRAY, IdeBundle.message((String)"scope.open.files", (Object[])new Object[0])));
        }
        Editor selectedTextEditor = ApplicationManager.getApplication().isDispatchThread() ? FileEditorManager.getInstance((Project)project).getSelectedTextEditor() : null;
        PsiFile currentFile = psiFile = selectedTextEditor == null ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(selectedTextEditor.getDocument());
        if (dataContext != null) {
            PsiElement dataContextElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (dataContextElement == null) {
                dataContextElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            if (dataContextElement == null && psiFile != null) {
                dataContextElement = psiFile;
            }
            if (dataContextElement != null) {
                if (!PlatformUtils.isCidr()) {
                    Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)dataContextElement);
                    if (module2 == null) {
                        module2 = (Module)LangDataKeys.MODULE.getData(dataContext);
                    }
                    if (module2 != null && !(ModuleType.get((Module)module2) instanceof InternalModuleType)) {
                        result2.add(module2.getModuleScope());
                    }
                }
                if (currentFile == null) {
                    currentFile = dataContextElement.getContainingFile();
                }
            }
        }
        if (currentFile != null || showEmptyScopes) {
            PsiElement[] psiElementArray;
            if (currentFile != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = currentFile;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            PsiElement[] scope = psiElementArray;
            result2.add(new LocalSearchScope(scope, IdeBundle.message((String)"scope.current.file", (Object[])new Object[0])));
        }
        if (currentSelection && selectedTextEditor != null && psiFile != null && (selectionModel = selectedTextEditor.getSelectionModel()).hasSelection() && (startElement = psiFile.findElementAt(start = selectionModel.getSelectionStart())) != null && (endElement = psiFile.findElementAt(end = selectionModel.getSelectionEnd())) != null && (parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement)) != null) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            PsiElement[] children2 = parent.getChildren();
            TextRange selection = new TextRange(start, end);
            for (PsiElement child : children2) {
                if (child instanceof PsiWhiteSpace || child.getContainingFile() == null || !selection.contains(child.getTextOffset())) continue;
                elements.add(child);
            }
            if (!elements.isEmpty()) {
                LocalSearchScope local = new LocalSearchScope(PsiUtilCore.toPsiElementArray(elements), IdeBundle.message((String)"scope.selection", (Object[])new Object[0]));
                result2.add(local);
            }
        }
        if (usageView) {
            PredefinedSearchScopeProviderImpl.addHierarchyScope(project, result2);
            UsageView selectedUsageView = UsageViewManager.getInstance((Project)project).getSelectedUsageView();
            if (selectedUsageView != null && !selectedUsageView.isSearchInProgress()) {
                THashSet usages = ContainerUtil.newTroveSet((Collection)selectedUsageView.getUsages());
                usages.removeAll(selectedUsageView.getExcludedUsages());
                if (prevSearchFiles) {
                    Set<VirtualFile> files = PredefinedSearchScopeProviderImpl.collectFiles((Set<Usage>)usages, true);
                    if (!files.isEmpty()) {
                        GlobalSearchScope prev = new GlobalSearchScope(project, (Set)usages){
                            private Set<VirtualFile> myFiles;
                            final /* synthetic */ Set val$usages;
                            {
                                this.val$usages = set2;
                                super(arg0);
                            }

                            @NotNull
                            public String getDisplayName() {
                                String string = IdeBundle.message((String)"scope.files.in.previous.search.result", (Object[])new Object[0]);
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            public synchronized boolean contains(@NotNull VirtualFile file2) {
                                if (file2 == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (this.myFiles == null) {
                                    this.myFiles = PredefinedSearchScopeProviderImpl.collectFiles(this.val$usages, false);
                                }
                                return this.myFiles.contains(file2);
                            }

                            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                                if (file1 == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                if (file2 == null) {
                                    1.$$$reportNull$$$0(3);
                                }
                                return 0;
                            }

                            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                                if (aModule == null) {
                                    1.$$$reportNull$$$0(4);
                                }
                                return true;
                            }

                            public boolean isSearchInLibraries() {
                                return true;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 2;
                                        break;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        n2 = 3;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "file";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "file1";
                                        break;
                                    }
                                    case 3: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "file2";
                                        break;
                                    }
                                    case 4: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "aModule";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getDisplayName";
                                        break;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray;
                                        objectArray[2] = "contains";
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        objectArray = objectArray;
                                        objectArray[2] = "compare";
                                        break;
                                    }
                                    case 4: {
                                        objectArray = objectArray;
                                        objectArray[2] = "isSearchInModuleContent";
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        };
                        result2.add(prev);
                    }
                } else {
                    ArrayList<PsiElement> results = new ArrayList<PsiElement>(usages.size());
                    for (Usage usage : usages) {
                        PsiElement element;
                        if (!(usage instanceof PsiElementUsage) || (element = ((PsiElementUsage)usage).getElement()) == null || !element.isValid() || element.getContainingFile() == null) continue;
                        results.add(element);
                    }
                    if (!results.isEmpty()) {
                        result2.add(new LocalSearchScope(PsiUtilCore.toPsiElementArray(results), IdeBundle.message((String)"scope.previous.search.results", (Object[])new Object[0])));
                    }
                }
            }
        }
        if ((favoritesManager = FavoritesManager.getInstance(project)) != null) {
            for (final String favorite : favoritesManager.getAvailableFavoritesListNames()) {
                List<TreeItem<Pair<AbstractUrl, String>>> rootUrls = favoritesManager.getFavoritesListRootUrls(favorite);
                if (rootUrls.isEmpty()) continue;
                result2.add(new GlobalSearchScope(project){

                    @NotNull
                    public String getDisplayName() {
                        String string = "Favorite '" + favorite + "'";
                        if (string == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public boolean contains(@NotNull VirtualFile file2) {
                        if (file2 == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return (Boolean)ReadAction.compute(() -> {
                            if (file2 == null) {
                                2.$$$reportNull$$$0(5);
                            }
                            return favoritesManager.contains(favorite, file2);
                        });
                    }

                    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                        if (file1 == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        if (file2 == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        return 0;
                    }

                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        if (aModule == null) {
                            2.$$$reportNull$$$0(4);
                        }
                        return true;
                    }

                    public boolean isSearchInLibraries() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$2";
                                break;
                            }
                            case 1: 
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file1";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file2";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "aModule";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getDisplayName";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "contains";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "compare";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray;
                                objectArray[2] = "isSearchInModuleContent";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray;
                                objectArray[2] = "lambda$contains$0";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            }
        }
        ContainerUtil.addIfNotNull((Collection)result2, (Object)PredefinedSearchScopeProviderImpl.getSelectedFilesScope(project, dataContext));
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)result2);
        if (arrayList == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void addHierarchyScope(@NotNull Project project, Collection<SearchScope> result2) {
        ToolWindow toolWindow;
        if (project == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(2);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.HIERARCHY)) == null) {
            return;
        }
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getSelectedContent();
        if (content == null) {
            return;
        }
        String name = content.getDisplayName();
        JComponent component = content.getComponent();
        if (!(component instanceof HierarchyBrowserBase)) {
            return;
        }
        HierarchyBrowserBase hierarchyBrowserBase = (HierarchyBrowserBase)((Object)component);
        PsiElement[] elements = hierarchyBrowserBase.getAvailableElements();
        if (elements.length > 0) {
            result2.add((SearchScope)new LocalSearchScope(elements, "Hierarchy '" + name + "' (visible nodes only)"));
        }
    }

    @Nullable
    private static SearchScope getSelectedFilesScope(Project project, @Nullable DataContext dataContext) {
        List selectedFiles;
        Object[] filesOrDirs;
        Object[] objectArray = filesOrDirs = dataContext == null ? null : (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (filesOrDirs != null && !(selectedFiles = ContainerUtil.filter((Object[])filesOrDirs, file2 -> !file2.isDirectory())).isEmpty()) {
            return GlobalSearchScope.filesScope((Project)project, (Collection)selectedFiles, (String)"Selected Files");
        }
        return null;
    }

    protected static Set<VirtualFile> collectFiles(Set<Usage> usages, boolean findFirst) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (Usage usage : usages) {
            VirtualFile file2;
            PsiFile psiFile;
            PsiElement psiElement;
            if (!(usage instanceof PsiElementUsage) || (psiElement = ((PsiElementUsage)usage).getElement()) == null || !psiElement.isValid() || (psiFile = psiElement.getContainingFile()) == null || (file2 = psiFile.getVirtualFile()) == null) continue;
            files.add(file2);
            if (!findFirst) continue;
            return files;
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedScopes";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addHierarchyScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

