/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractMemberInfoStorage<T extends PsiElement, C extends PsiElement, M extends MemberInfoBase<T>> {
    protected final HashMap<C, LinkedHashSet<C>> myClassToSubclassesMap = new HashMap();
    private final HashMap<C, Set<C>> myTargetClassToExtendingMap = new HashMap();
    private final HashMap<C, List<M>> myClassToMemberInfoMap = new HashMap();
    protected final C myClass;
    protected final MemberInfoBase.Filter<T> myFilter;
    private final HashMap<C, List<M>> myTargetClassToIntermediateMemberInfosMap = new HashMap();
    private final HashMap<C, LinkedHashSet<M>> myTargetClassToMemberInfosListMap = new HashMap();
    private final HashMap<C, HashSet<M>> myTargetClassToDuplicatedMemberInfosMap = new HashMap();

    public AbstractMemberInfoStorage(C aClass, MemberInfoBase.Filter<T> memberInfoFilter) {
        this.myClass = aClass;
        this.buildSubClassesMap(aClass);
        this.myFilter = memberInfoFilter;
    }

    private Set<C> getAllClasses() {
        return this.myClassToSubclassesMap.keySet();
    }

    public Set<C> getExtending(C baseClass) {
        HashSet<Object> result2 = (HashSet<Object>)this.myTargetClassToExtendingMap.get(baseClass);
        if (result2 == null) {
            result2 = new HashSet<Object>();
            result2.add(baseClass);
            Set<C> allClasses = this.getAllClasses();
            for (PsiElement aClass : allClasses) {
                if (!this.isInheritor(baseClass, aClass)) continue;
                result2.add(aClass);
            }
            this.myTargetClassToExtendingMap.put(baseClass, result2);
        }
        return result2;
    }

    protected abstract boolean isInheritor(C var1, C var2);

    protected abstract void buildSubClassesMap(C var1);

    public List<M> getClassMemberInfos(C aClass) {
        List result2 = (List)this.myClassToMemberInfoMap.get(aClass);
        if (result2 == null) {
            ArrayList temp = new ArrayList();
            this.extractClassMembers(aClass, temp);
            result2 = Collections.unmodifiableList(temp);
            this.myClassToMemberInfoMap.put(aClass, result2);
        }
        return result2;
    }

    protected abstract void extractClassMembers(C var1, ArrayList<M> var2);

    public List<M> getIntermediateMemberInfosList(C baseClass) {
        List<M> result2 = (List<M>)this.myTargetClassToIntermediateMemberInfosMap.get(baseClass);
        if (result2 == null) {
            Set<M> list2 = this.getIntermediateClassesMemberInfosList(baseClass, new HashSet());
            result2 = Collections.unmodifiableList(new ArrayList<M>(list2));
            this.myTargetClassToIntermediateMemberInfosMap.put(baseClass, result2);
        }
        return result2;
    }

    private Set<M> getIntermediateClassesMemberInfosList(C targetClass, Set<C> visited) {
        LinkedHashSet<M> result2 = (LinkedHashSet<M>)this.myTargetClassToMemberInfosListMap.get(targetClass);
        if (result2 == null) {
            result2 = new LinkedHashSet<M>();
            LinkedHashSet<C> subclasses = this.getSubclasses(targetClass);
            for (PsiElement subclass : subclasses) {
                List<M> memberInfos = this.getClassMemberInfos(subclass);
                result2.addAll(memberInfos);
            }
            for (PsiElement subclass : subclasses) {
                if (!visited.add(subclass)) continue;
                result2.addAll(this.getIntermediateClassesMemberInfosList(subclass, visited));
            }
            this.myTargetClassToMemberInfosListMap.put(targetClass, result2);
        }
        return result2;
    }

    protected LinkedHashSet<C> getSubclasses(C aClass) {
        return (LinkedHashSet)this.myClassToSubclassesMap.computeIfAbsent(aClass, k -> new LinkedHashSet());
    }

    public Set<M> getDuplicatedMemberInfos(C baseClass) {
        return (Set)this.myTargetClassToDuplicatedMemberInfosMap.computeIfAbsent(baseClass, k -> this.buildDuplicatedMemberInfos(baseClass));
    }

    private HashSet<M> buildDuplicatedMemberInfos(C baseClass) {
        HashSet<MemberInfoBase> result2 = new HashSet<MemberInfoBase>();
        List<M> memberInfos = this.getIntermediateMemberInfosList(baseClass);
        for (int i = 0; i < memberInfos.size(); ++i) {
            MemberInfoBase memberInfo = (MemberInfoBase)memberInfos.get(i);
            PsiElement member = memberInfo.getMember();
            for (int j = 0; j < i; ++j) {
                MemberInfoBase memberInfo1 = (MemberInfoBase)memberInfos.get(j);
                PsiElement member1 = memberInfo1.getMember();
                if (!this.memberConflict(member1, member)) continue;
                result2.add(memberInfo);
            }
        }
        return result2;
    }

    protected abstract boolean memberConflict(T var1, T var2);
}

