/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageViewUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberInplaceRenamer
extends VariableInplaceRenamer {
    private final PsiElement mySubstituted;
    private RangeMarker mySubstitutedRange;

    public MemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor) {
        if (elementToRename == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(0);
        }
        this(elementToRename, substituted, editor, elementToRename.getName(), elementToRename.getName());
    }

    public MemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor, String initialName, String oldName) {
        if (elementToRename == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(1);
        }
        super(elementToRename, editor, elementToRename.getProject(), initialName, oldName);
        this.mySubstituted = substituted;
        if (this.mySubstituted != null && this.mySubstituted != this.myElementToRename && this.mySubstituted.getTextRange() != null) {
            PsiFile containingFile = this.mySubstituted.getContainingFile();
            if (!this.notSameFile(containingFile.getVirtualFile(), containingFile)) {
                this.mySubstitutedRange = this.myEditor.getDocument().createRangeMarker(this.mySubstituted.getTextRange());
            }
        } else {
            this.mySubstitutedRange = null;
        }
        this.showDialogAdvertisement("RenameElement");
    }

    @Override
    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        MemberInplaceRenamer memberInplaceRenamer = new MemberInplaceRenamer(variable, this.getSubstituted(), editor, initialName, this.myOldName);
        if (memberInplaceRenamer == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(2);
        }
        return memberInplaceRenamer;
    }

    @Override
    protected boolean acceptReference(PsiReference reference) {
        PsiElement element = reference.getElement();
        TextRange textRange = this.getRangeToRename(reference);
        String referenceText = element.getText().substring(textRange.getStartOffset(), textRange.getEndOffset());
        return Comparing.strEqual((String)referenceText, (String)this.myElementToRename.getName());
    }

    @Override
    protected PsiElement checkLocalScope() {
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (currentFile != null) {
            return currentFile;
        }
        return super.checkLocalScope();
    }

    @Override
    protected PsiElement getNameIdentifier() {
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (currentFile == this.myElementToRename.getContainingFile()) {
            return super.getNameIdentifier();
        }
        if (currentFile != null) {
            PsiReference reference;
            PsiElement referenceExpression;
            int offset = this.myEditor.getCaretModel().getOffset();
            offset = TargetElementUtil.adjustOffset(currentFile, this.myEditor.getDocument(), offset);
            PsiElement elementAt = currentFile.findElementAt(offset);
            if (elementAt != null && (referenceExpression = elementAt.getParent()) != null && (reference = referenceExpression.getReference()) != null && reference.resolve() == this.myElementToRename) {
                return elementAt;
            }
            return null;
        }
        return null;
    }

    @Override
    protected boolean isIdentifier(String newName, Language language) {
        PsiNamedElement namedElement = this.getVariable();
        return namedElement != null ? RenameUtil.isValidName(this.myProject, (PsiElement)namedElement, newName) : super.isIdentifier(newName, language);
    }

    @Override
    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        PsiElement substituted;
        ArrayList<PsiReference> references = new ArrayList<PsiReference>(super.collectRefs(referencesSearchScope));
        PsiNamedElement variable = this.getVariable();
        if (variable != null && (substituted = this.getSubstituted()) != null && substituted != variable) {
            references.addAll(ReferencesSearch.search((PsiElement)substituted, (SearchScope)referencesSearchScope, (boolean)false).findAll());
        }
        return references;
    }

    @Override
    protected boolean notSameFile(@Nullable VirtualFile file2, @NotNull PsiFile containingFile) {
        PsiFile currentFile;
        if (containingFile == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(3);
        }
        if ((currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) == null) {
            return true;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        return manager.getTopLevelFile((PsiElement)containingFile) != manager.getTopLevelFile((PsiElement)currentFile);
    }

    @Override
    protected SearchScope getReferencesSearchScope(VirtualFile file2) {
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        return currentFile != null ? new LocalSearchScope((PsiElement)currentFile) : ProjectScope.getProjectScope((Project)this.myProject);
    }

    @Override
    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        PsiElement substituted;
        boolean showChooser = super.appendAdditionalElement(refs, stringUsages);
        PsiNamedElement variable = this.getVariable();
        if (variable != null && (substituted = this.getSubstituted()) != null) {
            this.appendAdditionalElement(stringUsages, variable, substituted);
            RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(substituted);
            HashMap<PsiElement, String> allRenames = new HashMap<PsiElement, String>();
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            processor2.prepareRenaming(substituted, "", allRenames, (SearchScope)new LocalSearchScope((PsiElement)currentFile));
            for (PsiElement element : allRenames.keySet()) {
                this.appendAdditionalElement(stringUsages, variable, element);
            }
        }
        return showChooser;
    }

    @Override
    protected boolean shouldCreateSnapshot() {
        return false;
    }

    @Override
    protected String getRefactoringId() {
        return null;
    }

    private void appendAdditionalElement(Collection<Pair<PsiElement, TextRange>> stringUsages, PsiNamedElement variable, PsiElement element) {
        PsiElement identifier;
        if (element != variable && element instanceof PsiNameIdentifierOwner && !this.notSameFile(null, element.getContainingFile()) && (identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)identifier, (Object)new TextRange(0, identifier.getTextLength())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefactoringRename(String newName, StartMarkAction markAction) {
        try {
            PsiNamedElement variable = this.getVariable();
            if (variable != null && !newName.equals(this.myOldName) && this.isIdentifier(newName, variable.getLanguage())) {
                PsiElement substituted = this.getSubstituted();
                if (substituted == null) {
                    return;
                }
                Runnable performRunnable = () -> {
                    if (DumbService.isDumb((Project)this.myProject)) {
                        DumbService.getInstance((Project)this.myProject).showDumbModeNotification("Refactorings cannot be performed while indexing is in progress");
                        return;
                    }
                    String commandName = RefactoringBundle.message((String)"renaming.0.1.to.2", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)variable), DescriptiveNameUtil.getDescriptiveName((PsiElement)variable), newName});
                    CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                        this.performRenameInner(substituted, newName);
                        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    }, commandName, null);
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    performRunnable.run();
                } else {
                    TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, performRunnable);
                }
            }
        }
        finally {
            try {
                ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
            }
            finally {
                FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
            }
        }
    }

    protected void performRenameInner(PsiElement element, String newName) {
        RenameProcessor renameProcessor = this.createRenameProcessor(element, newName);
        for (AutomaticRenamerFactory factory : (AutomaticRenamerFactory[])Extensions.getExtensions(AutomaticRenamerFactory.EP_NAME)) {
            if (factory.getOptionName() == null || !factory.isEnabled() || !factory.isApplicable(element)) continue;
            renameProcessor.addRenamerFactory(factory);
        }
        renameProcessor.run();
    }

    protected RenameProcessor createRenameProcessor(PsiElement element, String newName) {
        return new MyRenameProcessor(element, newName);
    }

    protected void restoreCaretOffsetAfterRename() {
        if (this.myBeforeRevert != null) {
            if (!this.myEditor.isDisposed()) {
                this.myEditor.getCaretModel().moveToOffset(this.myBeforeRevert.getEndOffset());
            }
            this.myBeforeRevert.dispose();
        }
    }

    @Override
    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(4);
        }
    }

    @Override
    protected void revertStateOnFinish() {
        Editor editor = InjectedLanguageUtil.getTopLevelEditor(this.myEditor);
        if (editor == FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor()) {
            ((EditorImpl)editor).startDumb();
        }
        this.revertState();
    }

    @Nullable
    public PsiElement getSubstituted() {
        PsiFile psiFile;
        if (this.mySubstituted != null && this.mySubstituted.isValid()) {
            if (this.mySubstituted instanceof PsiNameIdentifierOwner) {
                RangeMarker rangeMarker;
                if (Comparing.strEqual((String)this.myOldName, (String)((PsiNameIdentifierOwner)this.mySubstituted).getName())) {
                    return this.mySubstituted;
                }
                RangeMarker rangeMarker2 = rangeMarker = this.mySubstitutedRange != null ? this.mySubstitutedRange : this.myRenameOffset;
                if (rangeMarker != null) {
                    return PsiTreeUtil.findElementOfClassAtRange((PsiFile)this.mySubstituted.getContainingFile(), (int)rangeMarker.getStartOffset(), (int)rangeMarker.getEndOffset(), PsiNameIdentifierOwner.class);
                }
            }
            return this.mySubstituted;
        }
        if (this.mySubstitutedRange != null && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) != null) {
            return PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)this.mySubstitutedRange.getStartOffset(), (int)this.mySubstitutedRange.getEndOffset(), PsiNameIdentifierOwner.class);
        }
        return this.getVariable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/inplace/MemberInplaceRenamer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/inplace/MemberInplaceRenamer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createInplaceRenamerToRestart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notSameFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalElementsToRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyRenameProcessor
    extends RenameProcessor {
        public MyRenameProcessor(PsiElement element, String newName) {
            this(element, newName, RenamePsiElementProcessor.forElement(element));
        }

        public MyRenameProcessor(PsiElement element, String newName, RenamePsiElementProcessor elementProcessor) {
            super(MemberInplaceRenamer.this.myProject, element, newName, elementProcessor.isToSearchInComments(element), elementProcessor.isToSearchForTextOccurrences(element) && TextOccurrencesUtil.isSearchTextOccurencesEnabled(element));
        }

        @Override
        @Nullable
        protected String getRefactoringId() {
            return "refactoring.inplace.rename";
        }

        @Override
        public void doRun() {
            try {
                super.doRun();
            }
            finally {
                MemberInplaceRenamer.this.restoreCaretOffsetAfterRename();
            }
        }
    }
}

