/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.Expandable;
import java.util.function.Consumer;
import javax.swing.JComponent;

public abstract class ExpandableActions
extends DumbAwareAction {
    private final Consumer<Expandable> consumer;

    private ExpandableActions(Consumer<Expandable> consumer) {
        this.setEnabledInModalContext(true);
        this.consumer = consumer;
    }

    private static Expandable getExpandable(AnActionEvent event) {
        JComponent container;
        Object property;
        Object component = event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (component instanceof Expandable) {
            return (Expandable)component;
        }
        if (component instanceof JComponent && (property = (container = (JComponent)component).getClientProperty(Expandable.class)) instanceof Expandable) {
            return (Expandable)property;
        }
        return null;
    }

    public void update(AnActionEvent event) {
        boolean expected = this instanceof Collapse;
        Expandable expandable = ExpandableActions.getExpandable(event);
        event.getPresentation().setEnabled(expandable != null && expandable.isExpanded() == expected);
    }

    public void actionPerformed(AnActionEvent event) {
        Expandable expandable = ExpandableActions.getExpandable(event);
        if (expandable != null) {
            this.consumer.accept(expandable);
        }
    }

    public static final class Collapse
    extends ExpandableActions {
        public Collapse() {
            super(Expandable::collapse);
        }
    }

    public static final class Expand
    extends ExpandableActions {
        public Expand() {
            super(Expandable::expand);
        }
    }
}

