/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.Consumer;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReachableNodes {
    @NotNull
    private final LiteLinearGraph myGraph;
    @NotNull
    private final Flags myTempFlags;

    public ReachableNodes(@NotNull LiteLinearGraph graph) {
        if (graph == null) {
            ReachableNodes.$$$reportNull$$$0(0);
        }
        this.myGraph = graph;
        this.myTempFlags = new BitSetFlags(graph.nodesCount());
    }

    @NotNull
    public static UnsignedBitSet getReachableNodes(@NotNull LinearGraph permanentGraph, @Nullable Set<Integer> headNodeIndexes) {
        if (permanentGraph == null) {
            ReachableNodes.$$$reportNull$$$0(1);
        }
        if (headNodeIndexes == null) {
            UnsignedBitSet nodesVisibility = new UnsignedBitSet();
            nodesVisibility.set(0, permanentGraph.nodesCount() - 1, true);
            UnsignedBitSet unsignedBitSet = nodesVisibility;
            if (unsignedBitSet == null) {
                ReachableNodes.$$$reportNull$$$0(2);
            }
            return unsignedBitSet;
        }
        UnsignedBitSet result2 = new UnsignedBitSet();
        ReachableNodes getter = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentGraph));
        getter.walk(headNodeIndexes, (Consumer<Integer>)((Consumer)node -> result2.set((int)node, true)));
        UnsignedBitSet unsignedBitSet = result2;
        if (unsignedBitSet == null) {
            ReachableNodes.$$$reportNull$$$0(3);
        }
        return unsignedBitSet;
    }

    @NotNull
    public Set<Integer> getContainingBranches(int nodeIndex, @NotNull Collection<Integer> branchNodeIndexes) {
        if (branchNodeIndexes == null) {
            ReachableNodes.$$$reportNull$$$0(4);
        }
        HashSet<Integer> result2 = new HashSet<Integer>();
        this.walk(Collections.singletonList(nodeIndex), false, (Consumer<Integer>)((Consumer)node -> {
            if (branchNodeIndexes == null) {
                ReachableNodes.$$$reportNull$$$0(14);
            }
            if (branchNodeIndexes.contains(node)) {
                result2.add((Integer)node);
            }
        }));
        HashSet<Integer> hashSet = result2;
        if (hashSet == null) {
            ReachableNodes.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public void walk(@NotNull Collection<Integer> headIds, @NotNull Consumer<Integer> consumer) {
        if (headIds == null) {
            ReachableNodes.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            ReachableNodes.$$$reportNull$$$0(7);
        }
        this.walk(headIds, true, consumer);
    }

    private void walk(@NotNull Collection<Integer> startNodes, boolean goDown, @NotNull Consumer<Integer> consumer) {
        if (startNodes == null) {
            ReachableNodes.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            ReachableNodes.$$$reportNull$$$0(9);
        }
        this.walk(startNodes, goDown, (int node) -> {
            if (consumer == null) {
                ReachableNodes.$$$reportNull$$$0(13);
            }
            consumer.consume((Object)node);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walk(@NotNull Collection<Integer> startNodes, boolean goDown, @NotNull IntPredicate consumer) {
        if (startNodes == null) {
            ReachableNodes.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            ReachableNodes.$$$reportNull$$$0(11);
        }
        Flags flags = this.myTempFlags;
        synchronized (flags) {
            this.myTempFlags.setAll(false);
            for (int start : startNodes) {
                if (start < 0 || this.myTempFlags.get(start)) continue;
                this.myTempFlags.set(start, true);
                if (!consumer.test(start)) {
                    return;
                }
                DfsUtil.walk(start, currentNode -> {
                    if (consumer == null) {
                        ReachableNodes.$$$reportNull$$$0(12);
                    }
                    for (int downNode : this.myGraph.getNodes(currentNode, goDown ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP)) {
                        if (this.myTempFlags.get(downNode)) continue;
                        this.myTempFlags.set(downNode, true);
                        if (!consumer.test(downNode)) {
                            return -10;
                        }
                        return downNode;
                    }
                    return -1;
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraph";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/ReachableNodes";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNodeIndexes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headIds";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/ReachableNodes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReachableNodes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReachableNodes";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "walk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$walk$3";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$walk$2";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContainingBranches$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

