/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.BekUtil;
import icons.VcsLogIcons;
import org.jetbrains.annotations.NotNull;

public class IntelliSortChooserToggleAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private static final String DEFAULT_TEXT = "IntelliSort";
    @NotNull
    private static final String DEFAULT_DESCRIPTION = "Turn IntelliSort On/Off";

    public IntelliSortChooserToggleAction() {
        super(DEFAULT_TEXT, DEFAULT_DESCRIPTION, VcsLogIcons.IntelliSort);
    }

    public boolean isSelected(AnActionEvent e) {
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        return properties != null && properties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE) && !properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE).equals((Object)PermanentGraph.SortType.Normal);
    }

    public void setSelected(AnActionEvent e, boolean state2) {
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        if (properties != null && properties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE)) {
            PermanentGraph.SortType bekSortType = state2 ? PermanentGraph.SortType.Bek : PermanentGraph.SortType.Normal;
            properties.set(MainVcsLogUiProperties.BEK_SORT_TYPE, bekSortType);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            IntelliSortChooserToggleAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        e.getPresentation().setVisible(BekUtil.isBekEnabled());
        e.getPresentation().setEnabled(BekUtil.isBekEnabled() && logUI != null);
        if (properties != null && properties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE)) {
            boolean off = properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.Normal;
            String description = "Turn IntelliSort " + (off ? "on" : "off") + ": " + (off ? PermanentGraph.SortType.Bek.getDescription().toLowerCase() : PermanentGraph.SortType.Normal.getDescription().toLowerCase()) + ".";
            e.getPresentation().setDescription(description);
            e.getPresentation().setText(description);
        } else {
            e.getPresentation().setText(DEFAULT_TEXT);
            e.getPresentation().setDescription(DEFAULT_DESCRIPTION);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/IntelliSortChooserToggleAction", "update"));
    }
}

