/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MultipleValueFilterPopupComponent<Filter extends VcsLogFilter>
extends FilterPopupComponent<Filter> {
    private static final int MAX_FILTER_VALUE_LENGTH = 30;
    @NotNull
    protected final MainVcsLogUiProperties myUiProperties;

    MultipleValueFilterPopupComponent(@NotNull String filterName, @NotNull MainVcsLogUiProperties uiProperties, @NotNull FilterModel<Filter> filterModel) {
        if (filterName == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(1);
        }
        if (filterModel == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(2);
        }
        super(filterName, filterModel);
        this.myUiProperties = uiProperties;
    }

    @NotNull
    protected abstract List<List<String>> getRecentValuesFromSettings();

    protected abstract void rememberValuesInSettings(@NotNull Collection<String> var1);

    @NotNull
    protected abstract List<String> getAllValues();

    @NotNull
    protected ActionGroup createRecentItemsActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        List<List<String>> recentlyFiltered = this.getRecentValuesFromSettings();
        if (!recentlyFiltered.isEmpty()) {
            group.addSeparator("Recent");
            for (List<String> recentGroup : recentlyFiltered) {
                if (recentGroup.isEmpty()) continue;
                group.add((AnAction)new PredefinedValueAction(this, recentGroup));
            }
            group.addSeparator();
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    @NotNull
    static String displayableText(@NotNull Collection<String> values) {
        if (values == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(4);
        }
        if (values.size() == 1) {
            String string = values.iterator().next();
            if (string == null) {
                MultipleValueFilterPopupComponent.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = StringUtil.shortenTextWithEllipsis((String)StringUtil.join(values, (String)"|"), (int)30, (int)0, (boolean)true);
        if (string == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    static String tooltip(@NotNull Collection<String> values) {
        if (values == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(7);
        }
        String string = StringUtil.join(values, (String)", ");
        if (string == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected AnAction createSelectMultipleValuesAction() {
        SelectMultipleValuesAction selectMultipleValuesAction = new SelectMultipleValuesAction();
        if (selectMultipleValuesAction == null) {
            MultipleValueFilterPopupComponent.$$$reportNull$$$0(9);
        }
        return selectMultipleValuesAction;
    }

    protected boolean supportsNegativeValues() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecentItemsActionGroup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "displayableText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tooltip";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectMultipleValuesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "displayableText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SelectMultipleValuesAction
    extends DumbAwareAction {
        @NotNull
        private final Collection<String> myVariants;

        SelectMultipleValuesAction() {
            super("Select...");
            this.myVariants = MultipleValueFilterPopupComponent.this.getAllValues();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                SelectMultipleValuesAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            Object filter2 = MultipleValueFilterPopupComponent.this.myFilterModel.getFilter();
            List<String> values = filter2 == null ? Collections.emptyList() : MultipleValueFilterPopupComponent.this.myFilterModel.getFilterValues(filter2);
            final MultilinePopupBuilder popupBuilder = new MultilinePopupBuilder(project, this.myVariants, this.getPopupText(values), MultipleValueFilterPopupComponent.this.supportsNegativeValues());
            JBPopup popup2 = popupBuilder.createPopup();
            popup2.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    if (event.isOk()) {
                        List<String> selectedValues = popupBuilder.getSelectedValues();
                        if (selectedValues.isEmpty()) {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(null);
                        } else {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(MultipleValueFilterPopupComponent.this.myFilterModel.createFilter(selectedValues));
                            MultipleValueFilterPopupComponent.this.rememberValuesInSettings(selectedValues);
                        }
                    }
                }
            });
            popup2.showUnderneathOf((Component)MultipleValueFilterPopupComponent.this);
        }

        @NotNull
        private String getPopupText(@Nullable Collection<String> selectedValues) {
            String string = selectedValues == null || selectedValues.isEmpty() ? "" : StringUtil.join(selectedValues, (String)"\n");
            if (string == null) {
                SelectMultipleValuesAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$SelectMultipleValuesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$SelectMultipleValuesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopupText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class PredefinedValueAction
    extends DumbAwareAction {
        @NotNull
        protected final List<String> myValues;
        final /* synthetic */ MultipleValueFilterPopupComponent this$0;

        public PredefinedValueAction(@NotNull MultipleValueFilterPopupComponent this$0, String value) {
            if (value == null) {
                PredefinedValueAction.$$$reportNull$$$0(0);
            }
            this(this$0, Collections.singletonList(value));
        }

        public PredefinedValueAction(@NotNull MultipleValueFilterPopupComponent this$0, List<String> values) {
            if (values == null) {
                PredefinedValueAction.$$$reportNull$$$0(1);
            }
            this.this$0 = this$0;
            super(null, MultipleValueFilterPopupComponent.tooltip(values), null);
            this.getTemplatePresentation().setText(MultipleValueFilterPopupComponent.displayableText(values), false);
            this.myValues = values;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                PredefinedValueAction.$$$reportNull$$$0(2);
            }
            this.this$0.myFilterModel.setFilter(this.this$0.myFilterModel.createFilter(this.myValues));
            this.this$0.rememberValuesInSettings(this.myValues);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$PredefinedValueAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

