/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckTagEmptyBodyInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CollapseTagIntention
implements LocalQuickFix,
IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"xml.inspections.replace.tag.empty.body.with.empty.end", (Object[])new Object[0]);
        if (string == null) {
            CollapseTagIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            CollapseTagIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            CollapseTagIntention.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            CollapseTagIntention.$$$reportNull$$$0(3);
        }
        CollapseTagIntention.applyFix(project, descriptor2.getPsiElement());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        XmlTag tag;
        if (project == null) {
            CollapseTagIntention.$$$reportNull$$$0(4);
        }
        return (tag = CollapseTagIntention.getTag(editor, file2)) != null && !tag.isEmpty() && tag.getSubTags().length == 0 && tag.getValue().getTrimmedText().isEmpty() && CheckTagEmptyBodyInspection.isCollapsibleTag(tag);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        XmlTag tag;
        if (project == null) {
            CollapseTagIntention.$$$reportNull$$$0(5);
        }
        if ((tag = CollapseTagIntention.getTag(editor, file2)) != null) {
            CollapseTagIntention.applyFix(project, (PsiElement)tag);
        }
    }

    private static XmlTag getTag(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        FileViewProvider provider = file2.getViewProvider();
        for (Language language : provider.getLanguages()) {
            PsiElement element = provider.findElementAt(offset, language);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag == null || XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode()) == null) continue;
            return tag;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void applyFix(final @NotNull Project project, final @NotNull PsiElement tag) {
        if (project == null) {
            CollapseTagIntention.$$$reportNull$$$0(6);
        }
        if (tag == null) {
            CollapseTagIntention.$$$reportNull$$$0(7);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(tag.getContainingFile())) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        if (child == null) {
            return;
        }
        final int offset = child.getTextRange().getStartOffset();
        VirtualFile file2 = tag.getContainingFile().getVirtualFile();
        final Document document = FileDocumentManager.getInstance().getDocument(file2);
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                assert (document != null);
                document.replaceString(offset, tag.getTextRange().getEndOffset(), (CharSequence)"/>");
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                CodeStyleManager.getInstance((Project)project).reformat(tag);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xml/util/CollapseTagIntention$1", "run"));
            }
        }.execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/CollapseTagIntention";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/CollapseTagIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

