/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLineSeparatorUtil {
    private PyLineSeparatorUtil() {
    }

    @Nullable
    public static LineMarkerInfo addLineSeparatorIfNeeded(@NotNull Provider provider, @NotNull PsiElement element) {
        if (provider == null) {
            PyLineSeparatorUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PyLineSeparatorUtil.$$$reportNull$$$0(1);
        }
        Ref info = new Ref(null);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (provider == null) {
                PyLineSeparatorUtil.$$$reportNull$$$0(4);
            }
            if (element == null) {
                PyLineSeparatorUtil.$$$reportNull$$$0(5);
            }
            if (!provider.isSeparatorAllowed(element)) {
                return;
            }
            boolean hasSeparableBefore = false;
            PsiElement parent = element.getParent();
            if (parent == null) {
                return;
            }
            for (PsiElement child : parent.getChildren()) {
                if (child == element) break;
                if (!provider.isSeparatorAllowed(child)) continue;
                hasSeparableBefore = true;
                break;
            }
            if (!hasSeparableBefore) {
                return;
            }
            info.set(PyLineSeparatorUtil.createLineSeparatorByElement(element));
        });
        return (LineMarkerInfo)info.get();
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createLineSeparatorByElement(@NotNull PsiElement element) {
        if (element == null) {
            PyLineSeparatorUtil.$$$reportNull$$$0(2);
        }
        PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)element);
        LineMarkerInfo info = new LineMarkerInfo(anchor, anchor.getTextRange(), null, 11, null, null, GutterIconRenderer.Alignment.RIGHT);
        info.separatorColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            PyLineSeparatorUtil.$$$reportNull$$$0(3);
        }
        return lineMarkerInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/PyLineSeparatorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/PyLineSeparatorUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineSeparatorByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLineSeparatorIfNeeded";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLineSeparatorByElement";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addLineSeparatorIfNeeded$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Provider {
        public boolean isSeparatorAllowed(@Nullable PsiElement var1);
    }
}

