/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.completion.PyFunctionInsertHandler;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.PythonImportUtils;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import com.jetbrains.python.psi.types.PyModuleType;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class PyClassNameCompletionContributor
extends CompletionContributor {
    private static Condition<PsiElement> IS_TOPLEVEL = element -> PyUtil.isTopLevel(element);
    private static final InsertHandler<LookupElement> IMPORTING_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            PyClassNameCompletionContributor.addImportForLookupElement(context, item, context.getTailOffset() - 1);
        }
    };
    private static final InsertHandler<LookupElement> FUNCTION_INSERT_HANDLER = new PyFunctionInsertHandler(){

        @Override
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            if (item == null) {
                2.$$$reportNull$$$0(1);
            }
            int tailOffset = context.getTailOffset() - 1;
            super.handleInsert(context, item);
            context.commitDocument();
            PyClassNameCompletionContributor.addImportForLookupElement(context, item, tailOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor$2";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final InsertHandler<LookupElement> STRING_LITERAL_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            PsiElement element = item.getPsiElement();
            if (element instanceof PyQualifiedNameOwner) {
                String qName = ((PyQualifiedNameOwner)element).getQualifiedName();
                String name = ((PyQualifiedNameOwner)element).getName();
                if (qName != null && name != null) {
                    String qNamePrefix = qName.substring(0, qName.length() - name.length());
                    context.getDocument().insertString(context.getStartOffset(), (CharSequence)qNamePrefix);
                }
            }
        }
    };

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters.isExtendedCompletion()) {
            String prefix;
            PsiElement element = parameters.getPosition();
            PsiElement parent = element.getParent();
            if (parent instanceof PyReferenceExpression && ((PyReferenceExpression)parent).isQualified()) {
                return;
            }
            if (parent instanceof PyStringLiteralExpression && (prefix = parent.getText().substring(0, parameters.getOffset() - parent.getTextRange().getStartOffset())).contains(".")) {
                return;
            }
            FileViewProvider provider = element.getContainingFile().getViewProvider();
            if (provider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class) != null) {
                return;
            }
            PsiFile originalFile = parameters.getOriginalFile();
            PyClassNameCompletionContributor.addVariantsFromIndex(result2, originalFile, PyClassNameIndex.KEY, parent instanceof PyStringLiteralExpression ? STRING_LITERAL_INSERT_HANDLER : IMPORTING_INSERT_HANDLER, Conditions.alwaysTrue(), PyClass.class, PyClassNameCompletionContributor.createClassElementHandler(originalFile));
            PyClassNameCompletionContributor.addVariantsFromIndex(result2, originalFile, PyFunctionNameIndex.KEY, PyClassNameCompletionContributor.getFunctionInsertHandler(parent), IS_TOPLEVEL, PyFunction.class, Function.identity());
            PyClassNameCompletionContributor.addVariantsFromIndex(result2, originalFile, PyVariableNameIndex.KEY, parent instanceof PyStringLiteralExpression ? STRING_LITERAL_INSERT_HANDLER : IMPORTING_INSERT_HANDLER, IS_TOPLEVEL, PyTargetExpression.class, Function.identity());
            PyClassNameCompletionContributor.addVariantsFromModules(result2, originalFile, parent instanceof PyStringLiteralExpression);
        }
    }

    @NotNull
    private static Function<LookupElement, LookupElement> createClassElementHandler(@NotNull PsiFile file2) {
        PyFile pyFile;
        if (file2 == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((pyFile = PyUtil.as(file2, PyFile.class)) == null) {
            Function<LookupElement, LookupElement> function = Function.identity();
            if (function == null) {
                PyClassNameCompletionContributor.$$$reportNull$$$0(3);
            }
            return function;
        }
        Set sourceQNames = ContainerUtil.map2SetNotNull(pyFile.getFromImports(), PyFromImportStatement::getImportSourceQName);
        Function<LookupElement, LookupElement> function = le -> {
            PyClass cls = PyUtil.as(le.getPsiElement(), PyClass.class);
            if (cls == null) {
                return le;
            }
            String clsQName = cls.getQualifiedName();
            if (clsQName == null) {
                return le;
            }
            if (!sourceQNames.contains(QualifiedName.fromDottedString((String)clsQName).removeLastComponent())) {
                return le;
            }
            return PrioritizedLookupElement.withPriority((LookupElement)le, (double)5.0);
        };
        if (function == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(4);
        }
        return function;
    }

    private static InsertHandler<LookupElement> getFunctionInsertHandler(PsiElement parent) {
        if (parent instanceof PyStringLiteralExpression) {
            return STRING_LITERAL_INSERT_HANDLER;
        }
        if (parent.getParent() instanceof PyDecorator) {
            return IMPORTING_INSERT_HANDLER;
        }
        return FUNCTION_INSERT_HANDLER;
    }

    private static void addVariantsFromModules(CompletionResultSet result2, PsiFile targetFile, boolean inStringLiteral) {
        Collection<VirtualFile> files = FileTypeIndex.getFiles((FileType)PythonFileType.INSTANCE, PyProjectScopeBuilder.excludeSdkTestsScope((PsiElement)targetFile));
        for (VirtualFile file2 : files) {
            LookupElementBuilder element;
            PsiFile pyFile = targetFile.getManager().findFile(file2);
            PsiFileSystemItem importable = (PsiFileSystemItem)PyUtil.turnInitIntoDir((PsiElement)pyFile);
            if (importable == null || !PythonImportUtils.isImportableModule(targetFile, importable) || (element = PyModuleType.buildFileLookupElement(importable, null)) == null) continue;
            result2.addElement((LookupElement)element.withInsertHandler(inStringLiteral ? STRING_LITERAL_INSERT_HANDLER : IMPORTING_INSERT_HANDLER));
        }
    }

    private static <T extends PsiNamedElement> void addVariantsFromIndex(@NotNull CompletionResultSet resultSet, @NotNull PsiFile targetFile, @NotNull StubIndexKey<String, T> key, @NotNull InsertHandler<LookupElement> insertHandler, @NotNull Condition<? super T> condition, @NotNull Class<T> elementClass, @NotNull Function<LookupElement, LookupElement> elementHandler) {
        if (resultSet == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(5);
        }
        if (targetFile == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(6);
        }
        if (key == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(7);
        }
        if (insertHandler == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(8);
        }
        if (condition == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(9);
        }
        if (elementClass == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(10);
        }
        if (elementHandler == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(11);
        }
        Project project = targetFile.getProject();
        GlobalSearchScope scope = PyProjectScopeBuilder.excludeSdkTestsScope((PsiElement)targetFile);
        Collection keys = StubIndex.getInstance().getAllKeys(key, project);
        for (String elementName : CompletionUtil.sortMatching(resultSet.getPrefixMatcher(), keys)) {
            for (PsiNamedElement element : StubIndex.getElements(key, (Object)elementName, (Project)project, (GlobalSearchScope)scope, elementClass)) {
                String name;
                if (!condition.value((Object)element) || (name = element.getName()) == null) continue;
                LookupElementBuilder builder = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)element).withIcon(element.getIcon(0)).withTailText(" " + ((NavigationItem)element).getPresentation().getLocationString(), true).withInsertHandler(insertHandler);
                resultSet.addElement(elementHandler.apply((LookupElement)builder));
            }
        }
    }

    private static void addImportForLookupElement(final InsertionContext context, final LookupElement item, int tailOffset) {
        PsiReference ref;
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)context.getProject());
        Document document = manager.getDocument(context.getFile());
        if (document != null) {
            manager.commitDocument(document);
        }
        if ((ref = context.getFile().findReferenceAt(tailOffset)) == null || ref.resolve() == item.getPsiElement()) {
            return;
        }
        new WriteCommandAction(context.getProject(), new PsiFile[]{context.getFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                AddImportHelper.addImport(PyUtil.as(item.getPsiElement(), PsiNamedElement.class), context.getFile(), (PyElement)ref.getElement());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor$4", "run"));
            }
        }.execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassElementHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createClassElementHandler";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addVariantsFromIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

