/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PythonDocumentationMap", storages={@Storage(value="other.xml")})
public class PythonDocumentationMap
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static PythonDocumentationMap getInstance() {
        return (PythonDocumentationMap)ServiceManager.getService(PythonDocumentationMap.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state2) {
        this.myState = state2;
    }

    public List<Entry> getEntries() {
        return ImmutableList.copyOf(this.myState.getEntries());
    }

    public void setEntries(List<Entry> entries) {
        this.myState.setEntries(entries);
    }

    @Nullable
    public String urlFor(QualifiedName moduleQName, @Nullable PsiNamedElement element, String pyVersion) {
        for (Entry entry : this.myState.myEntries) {
            if (!moduleQName.matchesPrefix(QualifiedName.fromDottedString((String)entry.myPrefix))) continue;
            return PythonDocumentationMap.transformPattern(entry.myUrlPattern, moduleQName, element, pyVersion);
        }
        return null;
    }

    @Nullable
    public String rootUrlFor(QualifiedName moduleQName) {
        for (Entry entry : this.myState.myEntries) {
            if (!moduleQName.matchesPrefix(QualifiedName.fromDottedString((String)entry.myPrefix))) continue;
            return PythonDocumentationMap.rootForPattern(entry.myUrlPattern);
        }
        return null;
    }

    private static String rootForPattern(String urlPattern) {
        int pos = urlPattern.indexOf(123);
        return pos >= 0 ? urlPattern.substring(0, pos) : urlPattern;
    }

    @Nullable
    private static String transformPattern(@NotNull String urlPattern, QualifiedName moduleQName, @Nullable PsiNamedElement element, String pyVersion) {
        if (urlPattern == null) {
            PythonDocumentationMap.$$$reportNull$$$0(0);
        }
        HashMap<String, String> macros = new HashMap<String, String>();
        macros.put("element.name", element == null ? null : element.getName());
        PyClass pyClass = element == null ? null : (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        macros.put("class.name", pyClass == null ? null : pyClass.getName());
        if (element != null) {
            StringBuilder qName = new StringBuilder(moduleQName.toString()).append(".");
            if (element instanceof PyFunction && ((PyFunction)element).getContainingClass() != null) {
                qName.append(((PyFunction)element).getContainingClass().getName()).append(".");
            }
            qName.append(element.getName());
            macros.put("element.qname", qName.toString());
        } else {
            macros.put("element.qname", "");
        }
        macros.put("function.name", element instanceof PyFunction ? element.getName() : "");
        macros.put("module.name", moduleQName.toString());
        macros.put("python.version", pyVersion);
        String pattern = PythonDocumentationMap.transformPattern(urlPattern, macros);
        if (pattern == null) {
            return PythonDocumentationMap.rootForPattern(urlPattern);
        }
        return pattern;
    }

    @Nullable
    private static String transformPattern(@NotNull String urlPattern, Map<String, String> macroValues) {
        if (urlPattern == null) {
            PythonDocumentationMap.$$$reportNull$$$0(1);
        }
        for (Map.Entry<String, String> entry : macroValues.entrySet()) {
            if (entry.getValue() == null) {
                if (!urlPattern.contains("{" + entry.getKey())) continue;
                return null;
            }
            urlPattern = urlPattern.replace("{" + entry.getKey() + "}", entry.getValue()).replace("{" + entry.getKey() + ".lower}", entry.getValue().toLowerCase()).replace("{" + entry.getKey() + ".slashes}", entry.getValue().replace(".", "/")).replace("{" + entry.getKey() + ".dashes}", entry.getValue().replace("_", "-"));
        }
        return urlPattern.replace("{}", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlPattern", "com/jetbrains/python/documentation/PythonDocumentationMap", "transformPattern"));
    }

    public static class State {
        private List<Entry> myEntries = new ArrayList<Entry>();

        public State() {
            this.addEntry("PyQt4", "http://www.riverbankcomputing.co.uk/static/Docs/PyQt4/html/{class.name.lower}.html#{function.name}");
            this.addEntry("PySide", "http://pyside.github.io/docs/pyside/{module.name.slashes}/{class.name}.html#{module.name}.{element.qname}");
            this.addEntry("gtk", "http://library.gnome.org/devel/pygtk/stable/class-gtk{class.name.lower}.html#method-gtk{class.name.lower}--{function.name.dashes}");
            this.addEntry("wx", "http://www.wxpython.org/docs/api/{module.name}.{class.name}-class.html#{function.name}");
            this.addEntry("numpy", "http://docs.scipy.org/doc/numpy/reference/{}generated/{module.name}.{element.name}.html");
            this.addEntry("scipy", "http://docs.scipy.org/doc/scipy/reference/{}generated/{module.name}.{element.name}.html");
            this.addEntry("kivy", "http://kivy.org/docs/api-{module.name}.html");
        }

        public List<Entry> getEntries() {
            return this.myEntries;
        }

        public void setEntries(List<Entry> entries) {
            this.myEntries = entries;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state2 = (State)o;
            return Sets.newHashSet(this.myEntries).equals(Sets.newHashSet(state2.getEntries()));
        }

        public int hashCode() {
            return this.myEntries != null ? this.myEntries.hashCode() : 0;
        }

        private void addEntry(String qName, String pattern) {
            this.myEntries.add(new Entry(qName, pattern));
        }
    }

    public static class Entry {
        private String myPrefix;
        private String myUrlPattern;

        public Entry() {
        }

        public Entry(String prefix, String urlPattern) {
            this.myPrefix = prefix;
            this.myUrlPattern = urlPattern;
        }

        public String getPrefix() {
            return this.myPrefix;
        }

        public String getUrlPattern() {
            return this.myUrlPattern;
        }

        public void setPrefix(String prefix) {
            this.myPrefix = prefix;
        }

        public void setUrlPattern(String urlPattern) {
            this.myUrlPattern = urlPattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.myPrefix.equals(entry.myPrefix)) {
                return false;
            }
            return this.myUrlPattern.equals(entry.myUrlPattern);
        }

        public int hashCode() {
            int result2 = this.myPrefix.hashCode();
            result2 = 31 * result2 + this.myUrlPattern.hashCode();
            return result2;
        }
    }
}

