/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.StaticSymbolWhiteSpaceDefinitionStrategy;
import com.jetbrains.python.editor.PythonEnterHandler;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import gnu.trove.TIntIntHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class PyWhiteSpaceFormattingStrategy
extends StaticSymbolWhiteSpaceDefinitionStrategy {
    public PyWhiteSpaceFormattingStrategy() {
        super('\\');
    }

    @Override
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        CharSequence whiteSpace;
        if (whiteSpaceText == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(0);
        }
        if (startElement == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(1);
        }
        if ((whiteSpace = super.adjustWhiteSpaceIfNecessary(whiteSpaceText, startElement, startOffset, endOffset, codeStyleSettings)).length() > 0 && whiteSpace.charAt(0) == '\n' && !StringUtil.contains((CharSequence)whiteSpace, (int)0, (int)whiteSpace.length(), (char)'\\') && PythonEnterHandler.needInsertBackslash(startElement.getContainingFile(), startOffset, false)) {
            return PyWhiteSpaceFormattingStrategy.addBackslashPrefix(whiteSpace, codeStyleSettings);
        }
        return whiteSpace;
    }

    private static String addBackslashPrefix(CharSequence whiteSpace, CodeStyleSettings settings) {
        PyCodeStyleSettings pySettings = (PyCodeStyleSettings)settings.getCustomSettings(PyCodeStyleSettings.class);
        return (pySettings.SPACE_BEFORE_BACKSLASH ? " \\" : "\\") + whiteSpace.toString();
    }

    @Override
    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        TIntIntHashMap initialBackSlashes;
        if (whiteSpaceText == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(2);
        }
        if (text == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(3);
        }
        if ((initialBackSlashes = PyWhiteSpaceFormattingStrategy.countBackSlashes(text, startOffset, endOffset)).isEmpty()) {
            if (nodeAfter != null && whiteSpaceText.length() > 0 && whiteSpaceText.charAt(0) == '\n' && PythonEnterHandler.needInsertBackslash(nodeAfter, false)) {
                String string = PyWhiteSpaceFormattingStrategy.addBackslashPrefix(whiteSpaceText, codeStyleSettings);
                if (string == null) {
                    PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(4);
                }
                return string;
            }
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        TIntIntHashMap newBackSlashes = PyWhiteSpaceFormattingStrategy.countBackSlashes(whiteSpaceText, 0, whiteSpaceText.length());
        AtomicBoolean continueProcessing = new AtomicBoolean();
        initialBackSlashes.forEachKey(key -> {
            if (!newBackSlashes.containsKey(key)) {
                continueProcessing.set(true);
                return false;
            }
            return true;
        });
        if (!continueProcessing.get()) {
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(6);
            }
            return charSequence;
        }
        PyCodeStyleSettings settings = (PyCodeStyleSettings)codeStyleSettings.getCustomSettings(PyCodeStyleSettings.class);
        StringBuilder result2 = new StringBuilder();
        int line = 0;
        for (int i = 0; i < whiteSpaceText.length(); ++i) {
            char c = whiteSpaceText.charAt(i);
            if (c != '\n') {
                result2.append(c);
                continue;
            }
            if (!newBackSlashes.contains(line++)) {
                if ((i == 0 || i > 0 && whiteSpaceText.charAt(i - 1) != ' ') && settings.SPACE_BEFORE_BACKSLASH) {
                    result2.append(' ');
                }
                result2.append('\\');
            }
            result2.append(c);
        }
        StringBuilder stringBuilder = result2;
        if (stringBuilder == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(7);
        }
        return stringBuilder;
    }

    static TIntIntHashMap countBackSlashes(CharSequence text, int start, int end) {
        TIntIntHashMap result2 = new TIntIntHashMap();
        int line = 0;
        if (end > text.length()) {
            end = text.length();
        }
        block4: for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    ++line;
                    continue block4;
                }
                case '\\': {
                    result2.put(line, 1);
                }
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustWhiteSpaceIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

