/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyReferenceExpression;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDeprecationInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Deprecated function, class or module" == null) {
            PyDeprecationInspection.$$$reportNull$$$0(0);
        }
        return "Deprecated function, class or module";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyDeprecationInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyDeprecationInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyDeprecationInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyDeprecationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyDeprecationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            PyExpression exceptClass;
            PyExceptPart exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyExceptPart.class);
            if (exceptPart != null && (exceptClass = exceptPart.getExceptClass()) != null && "ImportError".equals(exceptClass.getText())) {
                return;
            }
            PsiElement resolveResult = node.getReference(this.getResolveContext()).resolve();
            PyFromImportStatement importStatement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyFromImportStatement.class);
            if (importStatement != null) {
                PsiFileSystemItem element = importStatement.resolveImportSource();
                if (resolveResult != null && element != resolveResult.getContainingFile()) {
                    return;
                }
            }
            String deprecationMessage = null;
            if (resolveResult instanceof PyFunction) {
                deprecationMessage = ((PyFunction)resolveResult).getDeprecationMessage();
            } else if (resolveResult instanceof PyFile) {
                deprecationMessage = ((PyFile)resolveResult).getDeprecationMessage();
            }
            if (deprecationMessage != null) {
                ASTNode nameElement = node.getNameElement();
                this.registerProblem((PsiElement)(nameElement == null ? node : nameElement.getPsi()), deprecationMessage, ProblemHighlightType.LIKE_DEPRECATED);
            }
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            super.visitPyFunction(node);
            PyDecoratorList decoratorList = node.getDecoratorList();
            if (LanguageLevel.forElement(node).isAtLeast(LanguageLevel.PYTHON33) && decoratorList != null) {
                Arrays.stream(decoratorList.getDecorators()).filter(decorator -> PyKnownDecoratorUtil.asKnownDecorators(decorator, this.myTypeEvalContext).contains((Object)PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTPROPERTY)).forEach(decorator -> {
                    QualifiedName abcAbsPropertyQName = PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTPROPERTY.getQualifiedName();
                    QualifiedName propertyQName = PyKnownDecoratorUtil.KnownDecorator.PROPERTY.getQualifiedName();
                    QualifiedName abcAbsMethodQName = PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTMETHOD.getQualifiedName();
                    String message = "'" + abcAbsPropertyQName + "' is deprecated since Python 3.3. Use '" + propertyQName + "' with '" + abcAbsMethodQName + "' instead.";
                    this.registerProblem((PsiElement)decorator, message, ProblemHighlightType.LIKE_DEPRECATED);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDeprecationInspection$Visitor", "<init>"));
        }
    }
}

