/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyListLiteralExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ListCreationQuickFix
implements LocalQuickFix {
    private final PyAssignmentStatement myStatement;
    private final List<PyExpressionStatement> myStatements = new ArrayList<PyExpressionStatement>();

    public ListCreationQuickFix(PyAssignmentStatement statement) {
        this.myStatement = statement;
    }

    public void addStatement(PyExpressionStatement statement) {
        this.myStatements.add(statement);
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.list.creation", new Object[0]);
        if (string == null) {
            ListCreationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            ListCreationQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            ListCreationQuickFix.$$$reportNull$$$0(2);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        StringBuilder stringBuilder = new StringBuilder();
        PyExpression assignedValue = this.myStatement.getAssignedValue();
        if (assignedValue == null) {
            return;
        }
        for (PyExpression expression : ((PyListLiteralExpression)assignedValue).getElements()) {
            stringBuilder.append(expression.getText()).append(", ");
        }
        for (PyExpressionStatement statement : this.myStatements) {
            for (PyExpression expr : ((PyCallExpression)statement.getExpression()).getArguments()) {
                stringBuilder.append(expr.getText()).append(", ");
            }
            statement.delete();
        }
        assignedValue.replace((PsiElement)elementGenerator.createExpressionFromText("[" + stringBuilder.substring(0, stringBuilder.length() - 2) + "]"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/ListCreationQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/ListCreationQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

