/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PyRemoveParameterQuickFix
implements LocalQuickFix {
    @NotNull
    private final TypeEvalContext myContext;

    public PyRemoveParameterQuickFix(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyRemoveParameterQuickFix.$$$reportNull$$$0(0);
        }
        this.myContext = context;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.NAME.remove.parameter", new Object[0]);
        if (string == null) {
            PyRemoveParameterQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            PyRemoveParameterQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            PyRemoveParameterQuickFix.$$$reportNull$$$0(3);
        }
        PyParameter psi = PyUtil.as(descriptor2.getPsiElement(), PyParameter.class);
        assert (psi != null);
        PyCallableParameter parameter = PyCallableParameterImpl.psi(psi);
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)psi, PyFunction.class);
        if (function != null) {
            PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myContext);
            ((StreamEx)StreamEx.of(PyRefactoringUtil.findUsages(function, false)).map(UsageInfo::getElement).nonNull().map(PsiElement::getParent).select(PyCallExpression.class).flatCollection(callExpression -> callExpression.multiMapArguments(resolveContext)).flatCollection(mapping -> mapping.getMappedParameters().entrySet()).filter(entry -> parameter.equals(entry.getValue()))).forEach(entry -> ((PyExpression)entry.getKey()).delete());
            PyStringLiteralExpression docStringExpression = function.getDocStringExpression();
            String parameterName = parameter.getName();
            if (docStringExpression != null && parameterName != null) {
                PyDocstringGenerator.forDocStringOwner(function).withoutParam(parameterName).buildAndInsert();
            }
            if (parameterName != null) {
                StreamEx.of(PyiUtil.getOverloads(function, this.myContext)).map(overload -> overload.getParameterList().getParameters()).map(parameters -> (PyParameter)ContainerUtil.find((Object[])parameters, overloadParameter -> parameterName.equals(overloadParameter.getName()))).nonNull().forEach(PsiElement::delete);
            }
        }
        psi.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyRemoveParameterQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyRemoveParameterQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

