/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.module;

import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.module.PyRootTypeProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PyContentEntriesEditor
extends CommonContentEntriesEditor {
    private final PyRootTypeProvider[] myRootTypeProviders = (PyRootTypeProvider[])Extensions.getExtensions(PyRootTypeProvider.EP_NAME);
    private final Module myModule;
    private Disposable myFilePointersDisposable;
    private MyContentEntryEditor myContentEntryEditor;
    private FacetErrorPanel myWarningPanel;

    public PyContentEntriesEditor(Module module2, ModuleConfigurationState moduleConfigurationState, boolean withBorders, JpsModuleSourceRootType<?> ... rootTypes) {
        super(module2.getName(), moduleConfigurationState, withBorders, rootTypes);
        this.myModule = module2;
        this.myWarningPanel = new FacetErrorPanel();
        this.reset();
    }

    public MyContentEntryEditor getContentEntryEditor() {
        return this.myContentEntryEditor;
    }

    @Override
    protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project) {
        return new MyContentEntryTreeEditor(project, this.getEditHandlers());
    }

    @Override
    protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
        List<ContentEntry> entries = super.addContentEntries(files);
        this.addContentEntryPanels(entries.toArray(new ContentEntry[entries.size()]));
        return entries;
    }

    public ContentEntry[] getContentEntries() {
        return this.getModel().getContentEntries();
    }

    @Override
    public void reset() {
        if (this.myFilePointersDisposable != null) {
            Disposer.dispose((Disposable)this.myFilePointersDisposable);
        }
        this.myFilePointersDisposable = Disposer.newDisposable();
        for (PyRootTypeProvider provider : this.myRootTypeProviders) {
            provider.reset(this.myFilePointersDisposable, this, this.myModule);
        }
        if (this.myRootTreeEditor != null) {
            ContentEntryEditor editor = this.myRootTreeEditor.getContentEntryEditor();
            if (editor != null) {
                editor.update();
            }
            this.myRootTreeEditor.update();
        }
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        if (this.myFilePointersDisposable != null) {
            Disposer.dispose((Disposable)this.myFilePointersDisposable);
        }
        for (PyRootTypeProvider provider : this.myRootTypeProviders) {
            provider.disposeUIResources(this.myModule);
        }
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        for (PyRootTypeProvider provider : this.myRootTypeProviders) {
            provider.apply(this.myModule);
        }
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        for (PyRootTypeProvider provider : this.myRootTypeProviders) {
            if (!provider.isModified(this.myModule)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
        this.myContentEntryEditor = new MyContentEntryEditor(contentEntryUrl, this.getEditHandlers());
        return this.myContentEntryEditor;
    }

    @Override
    protected void addAdditionalSettingsToPanel(JPanel mainPanel) {
        mainPanel.add((Component)this.myWarningPanel.getComponent(), "South");
    }

    public FacetErrorPanel getWarningPanel() {
        return this.myWarningPanel;
    }

    private class MyContentEntryTreeEditor
    extends ContentEntryTreeEditor {
        private final ChangeListener myListener;

        public MyContentEntryTreeEditor(Project project, List<ModuleSourceRootEditHandler<?>> handlers) {
            super(project, handlers);
            this.myListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MyContentEntryTreeEditor.this.update();
                }
            };
        }

        @Override
        public void setContentEntryEditor(ContentEntryEditor newEditor) {
            MyContentEntryEditor existingEditor = this.getContentEntryEditor();
            if (Comparing.equal((Object)existingEditor, (Object)newEditor)) {
                return;
            }
            if (existingEditor != null) {
                existingEditor.removeListener(this.myListener);
            }
            if (newEditor != null) {
                ((MyContentEntryEditor)newEditor).addListener(this.myListener);
            }
            super.setContentEntryEditor(newEditor);
        }

        @Override
        public MyContentEntryEditor getContentEntryEditor() {
            return (MyContentEntryEditor)super.getContentEntryEditor();
        }

        @Override
        protected void createEditingActions() {
            super.createEditingActions();
            for (PyRootTypeProvider provider : PyContentEntriesEditor.this.myRootTypeProviders) {
                ContentEntryEditingAction action = provider.createRootEntryEditingAction((JTree)this.myTree, PyContentEntriesEditor.this.myFilePointersDisposable, PyContentEntriesEditor.this, PyContentEntriesEditor.this.getModel());
                this.myEditingActionsGroup.add((AnAction)action);
                CustomShortcutSet shortcut = provider.getShortcut();
                if (shortcut == null) continue;
                action.registerCustomShortcutSet((ShortcutSet)shortcut, (JComponent)this.myTree);
            }
        }

        @Override
        protected TreeCellRenderer getContentEntryCellRenderer() {
            return new ContentEntryTreeCellRenderer(this, this.getEditHandlers()){

                @Override
                protected Icon updateIcon(ContentEntry entry, VirtualFile file2, Icon originalIcon) {
                    for (PyRootTypeProvider provider : PyContentEntriesEditor.this.myRootTypeProviders) {
                        if (!provider.hasRoot(file2, PyContentEntriesEditor.this)) continue;
                        return provider.getIcon();
                    }
                    return super.updateIcon(entry, file2, originalIcon);
                }
            };
        }
    }

    protected class MyContentEntryEditor
    extends ContentEntryEditor {
        private final EventDispatcher<ChangeListener> myEventDispatcher;

        public MyContentEntryEditor(String contentEntryUrl, List<ModuleSourceRootEditHandler<?>> handlers) {
            super(contentEntryUrl, handlers);
            this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        }

        @Override
        protected ModifiableRootModel getModel() {
            return PyContentEntriesEditor.this.getModel();
        }

        public void addListener(ChangeListener changeListener) {
            this.myEventDispatcher.addListener((EventListener)changeListener);
        }

        public void removeListener(ChangeListener changeListener) {
            this.myEventDispatcher.removeListener((EventListener)changeListener);
        }

        @Override
        protected ContentRootPanel createContentRootPane() {
            return new MyContentRootPanel();
        }

        @Override
        public void deleteContentFolder(ContentEntry contentEntry, ContentFolder folder) {
            for (PyRootTypeProvider provider : PyContentEntriesEditor.this.myRootTypeProviders) {
                if (!provider.isMine(folder)) continue;
                this.removeRoot(contentEntry, folder.getUrl(), provider);
                return;
            }
            super.deleteContentFolder(contentEntry, folder);
        }

        public void removeRoot(@Nullable ContentEntry contentEntry, String folder, PyRootTypeProvider provider) {
            VirtualFilePointer root;
            if (contentEntry == null) {
                contentEntry = this.getContentEntry();
            }
            if ((root = this.getRoot(provider, folder)) != null) {
                provider.removeRoot(contentEntry, root, this.getModel());
                this.fireUpdate();
            }
        }

        public void fireUpdate() {
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            this.update();
        }

        public VirtualFilePointer getRoot(PyRootTypeProvider provider, @NotNull String url) {
            if (url == null) {
                MyContentEntryEditor.$$$reportNull$$$0(0);
            }
            for (VirtualFilePointer filePointer : provider.getRoots().get((Object)this.getContentEntry())) {
                if (!Comparing.equal((String)filePointer.getUrl(), (String)url)) continue;
                return filePointer;
            }
            return null;
        }

        public void addRoot(PyRootTypeProvider provider, @NotNull VirtualFilePointer root) {
            if (root == null) {
                MyContentEntryEditor.$$$reportNull$$$0(1);
            }
            provider.getRoots().putValue((Object)this.getContentEntry(), (Object)root);
            this.fireUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        protected class MyContentRootPanel
        extends ContentRootPanel {
            public MyContentRootPanel() {
                super(MyContentEntryEditor.this, MyContentEntryEditor.this.getEditHandlers());
            }

            @Override
            @NotNull
            protected ContentEntryImpl getContentEntry() {
                ContentEntryImpl contentEntryImpl = (ContentEntryImpl)MyContentEntryEditor.this.getContentEntry();
                if (contentEntryImpl == null) {
                    MyContentRootPanel.$$$reportNull$$$0(0);
                }
                return contentEntryImpl;
            }

            @Override
            protected void addFolderGroupComponents() {
                super.addFolderGroupComponents();
                for (PyRootTypeProvider provider : PyContentEntriesEditor.this.myRootTypeProviders) {
                    MultiMap<ContentEntry, VirtualFilePointer> roots = provider.getRoots();
                    if (roots.get((Object)this.getContentEntry()).isEmpty()) continue;
                    JComponent sourcesComponent = this.createFolderGroupComponent(provider.getName() + " Folders", provider.createFolders(this.getContentEntry()), provider.getColor(), null);
                    this.add((Component)sourcesComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/module/PyContentEntriesEditor$MyContentEntryEditor$MyContentRootPanel", "getContentEntry"));
            }
        }
    }
}

