/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.ui.ToggleActionButton;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.InstalledPackagesPanel;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyExecutionFix;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import icons.PythonIcons;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInstalledPackagesPanel
extends InstalledPackagesPanel {
    private boolean myHasManagement;

    public PyInstalledPackagesPanel(@NotNull Project project, @NotNull PackagesNotificationPanel area) {
        if (project == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(0);
        }
        if (area == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(1);
        }
        super(project, area);
        this.myHasManagement = false;
    }

    private Sdk getSelectedSdk() {
        PyPackageManagementService service = (PyPackageManagementService)this.myPackageManagementService;
        return service != null ? service.getSdk() : null;
    }

    public void updateNotifications(@Nullable Sdk selectedSdk) {
        if (selectedSdk == null) {
            this.myNotificationArea.hide();
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            PyExecutionException exception = null;
            try {
                this.myHasManagement = PyPackageManager.getInstance(selectedSdk).hasManagement();
                if (!this.myHasManagement) {
                    throw new PyExecutionException("Python packaging tools not found", "pip", Collections.emptyList(), "", "", 0, (List<? extends PyExecutionFix>)ImmutableList.of((Object)new PyInstallPackageManagementFix()));
                }
            }
            catch (PyExecutionException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                return;
            }
            PyExecutionException problem = exception;
            application.invokeLater(() -> {
                if (selectedSdk == this.getSelectedSdk()) {
                    this.myNotificationArea.hide();
                    if (problem != null) {
                        boolean invalid = PythonSdkType.isInvalid(selectedSdk);
                        if (!invalid) {
                            StringBuilder builder = new StringBuilder(problem.getMessage());
                            builder.append(". ");
                            for (PyExecutionFix pyExecutionFix : problem.getFixes()) {
                                String key = "id" + pyExecutionFix.hashCode();
                                String link = "<a href=\"" + key + "\">" + pyExecutionFix.getName() + "</a>";
                                builder.append(link);
                                builder.append(" ");
                                this.myNotificationArea.addLinkHandler(key, () -> {
                                    Sdk sdk = this.getSelectedSdk();
                                    if (sdk != null) {
                                        fix.run(sdk);
                                        this.myNotificationArea.removeLinkHandler(key);
                                        this.updatePackages(PyPackageManagers.getInstance().getManagementService(this.myProject, sdk));
                                        this.updateNotifications(sdk);
                                    }
                                });
                            }
                            this.myNotificationArea.showWarning(builder.toString());
                        }
                        this.myInstallButton.setEnabled(!invalid && this.installEnabled());
                    }
                }
            }, ModalityState.any());
        });
    }

    @Override
    protected Set<String> getPackagesToPostpone() {
        return Sets.newHashSet((Object[])new String[]{"pip", "distutils", "setuptools"});
    }

    @Override
    protected boolean canUninstallPackage(InstalledPackage pkg) {
        String location;
        if (!this.myHasManagement) {
            return false;
        }
        Sdk sdk = this.getSelectedSdk();
        if (sdk == null) {
            return false;
        }
        if (!PyPackageUtil.packageManagementEnabled(sdk)) {
            return false;
        }
        if (PythonSdkType.isVirtualEnv(sdk) && pkg instanceof PyPackage && (location = ((PyPackage)pkg).getLocation()) != null && location.startsWith(PySdkUtil.getUserSite())) {
            return false;
        }
        String name = pkg.getName();
        return !"pip".equals(name) && !"setuptools".equals(name) && !"distribute".equals(name) && !"python".equals(name);
    }

    @Override
    protected boolean canInstallPackage(@NotNull InstalledPackage pyPackage) {
        if (pyPackage == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(2);
        }
        return this.installEnabled();
    }

    @Override
    protected boolean installEnabled() {
        if (!PyPackageUtil.packageManagementEnabled(this.getSelectedSdk())) {
            return false;
        }
        return this.myHasManagement;
    }

    @Override
    protected boolean canUpgradePackage(InstalledPackage pyPackage) {
        if (!PyPackageUtil.packageManagementEnabled(this.getSelectedSdk())) {
            return false;
        }
        return this.myHasManagement && !"python".equals(pyPackage.getName());
    }

    @NotNull
    protected ToggleActionButton[] getExtraActions() {
        ToggleActionButton[] toggleActionButtonArray = new ToggleActionButton[]{new ToggleActionButton("Use Conda Package Manager", PythonIcons.Python.Anaconda){

            public boolean isSelected(AnActionEvent e) {
                Sdk sdk = PyInstalledPackagesPanel.this.getSelectedSdk();
                return sdk != null && PyPackageManager.getInstance(sdk) instanceof PyCondaPackageManagerImpl && ((PyCondaPackageManagerImpl)PyPackageManager.getInstance(sdk)).useConda();
            }

            public void setSelected(AnActionEvent e, boolean state2) {
                Sdk sdk = PyInstalledPackagesPanel.this.getSelectedSdk();
                if (sdk == null) {
                    return;
                }
                PyPackageManager manager = PyPackageManager.getInstance(sdk);
                if (manager instanceof PyCondaPackageManagerImpl) {
                    ((PyCondaPackageManagerImpl)manager).useConda(state2);
                }
                PyInstalledPackagesPanel.this.updatePackages(PyInstalledPackagesPanel.this.myPackageManagementService);
            }

            public boolean isVisible() {
                Sdk sdk = PyInstalledPackagesPanel.this.getSelectedSdk();
                return sdk != null && PythonSdkType.isConda(sdk);
            }
        }};
        if (toggleActionButtonArray == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(3);
        }
        return toggleActionButtonArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canInstallPackage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class PyInstallPackageManagementFix
    implements PyExecutionFix {
        PyInstallPackageManagementFix() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("Install packaging tools" == null) {
                PyInstallPackageManagementFix.$$$reportNull$$$0(0);
            }
            return "Install packaging tools";
        }

        @Override
        public void run(final @NotNull Sdk sdk) {
            if (sdk == null) {
                PyInstallPackageManagementFix.$$$reportNull$$$0(1);
            }
            PyPackageManagerUI ui = new PyPackageManagerUI(PyInstalledPackagesPanel.this.myProject, sdk, new PyPackageManagerUI.Listener(){

                @Override
                public void started() {
                    PyInstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
                }

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    PyInstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                    PyPackageManager packageManager = PyPackageManager.getInstance(sdk);
                    PackageManagementService.ErrorDescription description = PyPackageManagementService.toErrorDescription(exceptions, sdk);
                    if (description != null) {
                        PackagesNotificationPanel.showError("Failed to install Python packaging tools", description);
                    }
                    packageManager.refresh();
                    PyInstalledPackagesPanel.this.updatePackages(PyPackageManagers.getInstance().getManagementService(PyInstalledPackagesPanel.this.myProject, sdk));
                    PyInstalledPackagesPanel.this.updateNotifications(sdk);
                }
            });
            ui.installManagement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$PyInstallPackageManagementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$PyInstallPackageManagementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

