/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.tox;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.testing.tox.PyToxConfiguration;
import com.jetbrains.python.testing.tox.PyToxConfigurationFactory;
import com.jetbrains.python.testing.tox.PyToxTestLocator;

public final class PyToxConfigurationProducer
extends RunConfigurationProducer<PyToxConfiguration> {
    private static final String TOX_FILE_NAME = "tox.ini";

    public PyToxConfigurationProducer() {
        super(PyToxConfigurationFactory.INSTANCE);
    }

    public boolean isConfigurationFromContext(PyToxConfiguration configuration, ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        VirtualFile virtualFile = location.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String currentPath = virtualFile.getParent().getCanonicalPath();
        String directoryPath2 = configuration.getWorkingDirectory();
        if (currentPath != null && directoryPath2 != null && !directoryPath2.equals(currentPath)) {
            return false;
        }
        return TOX_FILE_NAME.equals(virtualFile.getName());
    }

    protected boolean setupConfigurationFromContext(PyToxConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiFile file2 = ((PsiElement)sourceElement.get()).getContainingFile();
        if (file2 == null) {
            return false;
        }
        String envName = PyToxTestLocator.getEnvNameFromElement(file2);
        if (envName != null) {
            configuration.setRunOnlyEnvs(envName);
            configuration.setName(String.format("Tox: run on %s", envName));
            return true;
        }
        PsiDirectory directory2 = file2.getContainingDirectory();
        if (directory2 == null) {
            return false;
        }
        configuration.setWorkingDirectory(directory2.getVirtualFile().getCanonicalPath());
        if (TOX_FILE_NAME.equals(file2.getName())) {
            configuration.setName("Tox");
            return true;
        }
        return false;
    }
}

