/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.vp;

import com.google.common.base.Preconditions;
import com.jetbrains.python.vp.Creator;
import com.jetbrains.python.vp.Presenter;
import com.jetbrains.python.vp.PresenterHandler;
import com.jetbrains.python.vp.ViewHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.NotNull;

public final class ViewPresenterUtils {
    private ViewPresenterUtils() {
    }

    public static <V, P extends Presenter> void linkViewWithPresenterAndLaunch(@NotNull Class<P> presenterInterface, @NotNull Class<V> viewInterface, @NotNull Creator<V, P> creator) {
        if (presenterInterface == null) {
            ViewPresenterUtils.$$$reportNull$$$0(0);
        }
        if (viewInterface == null) {
            ViewPresenterUtils.$$$reportNull$$$0(1);
        }
        if (creator == null) {
            ViewPresenterUtils.$$$reportNull$$$0(2);
        }
        Preconditions.checkArgument((boolean)presenterInterface.isInterface(), (Object)"Presenter is not interface");
        Preconditions.checkArgument((boolean)viewInterface.isInterface(), (Object)"View is not interface");
        PresenterHandler<P> presenterHandler = new PresenterHandler<P>();
        ViewHandler<V> viewHandler = new ViewHandler<V>();
        V viewProxy = ViewPresenterUtils.createProxy(viewInterface, viewHandler);
        Presenter presenterProxy = (Presenter)ViewPresenterUtils.createProxy(presenterInterface, presenterHandler);
        V realView = creator.createView(presenterProxy);
        viewHandler.setRealView(realView);
        P realPresenter = creator.createPresenter(viewProxy);
        presenterHandler.setRealPresenter(realPresenter);
        realPresenter.launch();
    }

    private static <C> C createProxy(Class<C> clazz, InvocationHandler handler2) {
        assert (clazz != null);
        assert (handler2 != null);
        return (C)Proxy.newProxyInstance(ViewPresenterUtils.class.getClassLoader(), new Class[]{clazz}, handler2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "presenterInterface";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "viewInterface";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "creator";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/vp/ViewPresenterUtils";
        objectArray[2] = "linkViewWithPresenterAndLaunch";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

