/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.service.JpsServiceManager;

public abstract class JpsJavaDependenciesEnumerationHandler {
    public static List<JpsJavaDependenciesEnumerationHandler> createHandlers(Collection<JpsModule> rootModules) {
        List handlers = null;
        for (Factory factory : JpsServiceManager.getInstance().getExtensions(Factory.class)) {
            JpsJavaDependenciesEnumerationHandler handler2 = factory.createHandler(rootModules);
            if (handler2 == null) continue;
            if (handlers == null) {
                handlers = new SmartList();
            }
            handlers.add(handler2);
        }
        return handlers;
    }

    public static boolean shouldProcessDependenciesRecursively(List<JpsJavaDependenciesEnumerationHandler> handlers) {
        if (handlers != null) {
            for (JpsJavaDependenciesEnumerationHandler handler2 : handlers) {
                if (handler2.shouldProcessDependenciesRecursively()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return false;
    }

    public boolean isProductionOnTestsDependency(JpsDependencyElement element) {
        return false;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return true;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return true;
    }

    public static abstract class Factory {
        @Nullable
        public abstract JpsJavaDependenciesEnumerationHandler createHandler(@NotNull Collection<JpsModule> var1);
    }
}

