/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.util.GitFileUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileRevision
extends VcsFileRevisionEx
implements Comparable<VcsFileRevision> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final GitRevisionNumber myRevision;
    @Nullable
    private final Couple<Couple<String>> myAuthorAndCommitter;
    @Nullable
    private final String myMessage;
    @Nullable
    private final String myBranch;
    @Nullable
    private final Date myAuthorTime;
    @NotNull
    private final Collection<String> myParents;
    @Nullable
    private final VirtualFile myRoot;

    public GitFileRevision(@NotNull Project project, @NotNull FilePath path, @NotNull GitRevisionNumber revision) {
        if (project == null) {
            GitFileRevision.$$$reportNull$$$0(0);
        }
        if (path == null) {
            GitFileRevision.$$$reportNull$$$0(1);
        }
        if (revision == null) {
            GitFileRevision.$$$reportNull$$$0(2);
        }
        this(project, null, path, revision, null, null, null, null, Collections.emptyList());
    }

    public GitFileRevision(@NotNull Project project, @Nullable VirtualFile root, @NotNull FilePath path, @NotNull GitRevisionNumber revision, @Nullable Couple<Couple<String>> authorAndCommitter, @Nullable String message, @Nullable String branch, @Nullable Date authorTime, @NotNull Collection<String> parents) {
        if (project == null) {
            GitFileRevision.$$$reportNull$$$0(3);
        }
        if (path == null) {
            GitFileRevision.$$$reportNull$$$0(4);
        }
        if (revision == null) {
            GitFileRevision.$$$reportNull$$$0(5);
        }
        if (parents == null) {
            GitFileRevision.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.myRoot = root;
        this.myPath = path;
        this.myRevision = revision;
        this.myAuthorAndCommitter = authorAndCommitter;
        this.myMessage = message;
        this.myBranch = branch;
        this.myAuthorTime = authorTime;
        this.myParents = parents;
    }

    @NotNull
    public FilePath getPath() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            GitFileRevision.$$$reportNull$$$0(7);
        }
        return filePath;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        GitRevisionNumber gitRevisionNumber = this.myRevision;
        if (gitRevisionNumber == null) {
            GitFileRevision.$$$reportNull$$$0(8);
        }
        return gitRevisionNumber;
    }

    public Date getRevisionDate() {
        return this.myRevision.getTimestamp();
    }

    @Nullable
    public Date getAuthorDate() {
        return this.myAuthorTime;
    }

    @Nullable
    public String getAuthor() {
        if (this.myAuthorAndCommitter != null) {
            return (String)((Couple)this.myAuthorAndCommitter.getFirst()).getFirst();
        }
        return null;
    }

    @Nullable
    public String getAuthorEmail() {
        if (this.myAuthorAndCommitter != null) {
            return (String)((Couple)this.myAuthorAndCommitter.getFirst()).getSecond();
        }
        return null;
    }

    @Nullable
    public String getCommitterName() {
        if (this.myAuthorAndCommitter != null) {
            return this.myAuthorAndCommitter.getSecond() == null ? null : (String)((Couple)this.myAuthorAndCommitter.getSecond()).getFirst();
        }
        return null;
    }

    @Nullable
    public String getCommitterEmail() {
        if (this.myAuthorAndCommitter != null) {
            return this.myAuthorAndCommitter.getSecond() == null ? null : (String)((Couple)this.myAuthorAndCommitter.getSecond()).getSecond();
        }
        return null;
    }

    @Nullable
    public String getCommitMessage() {
        return this.myMessage;
    }

    @Nullable
    public String getBranchName() {
        return this.myBranch;
    }

    public synchronized byte[] loadContent() throws VcsException {
        VirtualFile root = this.getRoot();
        return GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myPath));
    }

    private VirtualFile getRoot() throws VcsException {
        return this.myRoot != null ? this.myRoot : GitUtil.getGitRoot(this.myPath);
    }

    public synchronized byte[] getContent() throws VcsException {
        return this.loadContent();
    }

    @Override
    public int compareTo(VcsFileRevision rev) {
        if (rev instanceof GitFileRevision) {
            return this.myRevision.compareTo((VcsRevisionNumber)((GitFileRevision)rev).myRevision);
        }
        return this.getRevisionDate().compareTo(rev.getRevisionDate());
    }

    public String toString() {
        return this.myPath.getName() + ":" + this.myRevision.getShortRev();
    }

    @NotNull
    public Collection<String> getParents() {
        Collection<String> collection = this.myParents;
        if (collection == null) {
            GitFileRevision.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public String getHash() {
        String string = this.myRevision.getRev();
        if (string == null) {
            GitFileRevision.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitFileRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitFileRevision";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

