/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPushTagMode;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Git.Settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GitVcsSettings
implements PersistentStateComponent<State>,
DvcsSyncSettings {
    private static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;
    private final GitVcsApplicationSettings myAppSettings;
    private State myState = new State();

    public GitVcsSettings(GitVcsApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
    }

    public GitVcsApplicationSettings getAppSettings() {
        return this.myAppSettings;
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)PeriodicalTasksCloser.getInstance().safeGetService(project, GitVcsSettings.class);
    }

    @NotNull
    public UpdateMethod getUpdateType() {
        UpdateMethod updateMethod = (UpdateMethod)((Object)ObjectUtils.notNull((Object)((Object)this.myState.UPDATE_TYPE), (Object)((Object)UpdateMethod.BRANCH_DEFAULT)));
        if (updateMethod == null) {
            GitVcsSettings.$$$reportNull$$$0(0);
        }
        return updateMethod;
    }

    public void setUpdateType(UpdateMethod updateType) {
        this.myState.UPDATE_TYPE = updateType;
    }

    @NotNull
    public UpdateChangesPolicy updateChangesPolicy() {
        UpdateChangesPolicy updateChangesPolicy = this.myState.UPDATE_CHANGES_POLICY;
        if (updateChangesPolicy == null) {
            GitVcsSettings.$$$reportNull$$$0(1);
        }
        return updateChangesPolicy;
    }

    public void setUpdateChangesPolicy(UpdateChangesPolicy value) {
        this.myState.UPDATE_CHANGES_POLICY = value;
    }

    public void saveCommitAuthor(String author) {
        this.myState.PREVIOUS_COMMIT_AUTHORS.remove(author);
        while (this.myState.PREVIOUS_COMMIT_AUTHORS.size() >= 16) {
            this.myState.PREVIOUS_COMMIT_AUTHORS.remove(this.myState.PREVIOUS_COMMIT_AUTHORS.size() - 1);
        }
        this.myState.PREVIOUS_COMMIT_AUTHORS.add(0, author);
    }

    public String[] getCommitAuthors() {
        return ArrayUtil.toStringArray(this.myState.PREVIOUS_COMMIT_AUTHORS);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public boolean autoUpdateIfPushRejected() {
        return this.myState.PUSH_AUTO_UPDATE;
    }

    public void setAutoUpdateIfPushRejected(boolean autoUpdate) {
        this.myState.PUSH_AUTO_UPDATE = autoUpdate;
    }

    public boolean shouldUpdateAllRootsIfPushRejected() {
        return this.myState.PUSH_UPDATE_ALL_ROOTS;
    }

    public void setUpdateAllRootsIfPushRejected(boolean updateAllRoots) {
        this.myState.PUSH_UPDATE_ALL_ROOTS = updateAllRoots;
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        DvcsSyncSettings.Value value = this.myState.ROOT_SYNC;
        if (value == null) {
            GitVcsSettings.$$$reportNull$$$0(2);
        }
        return value;
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value syncSetting) {
        if (syncSetting == null) {
            GitVcsSettings.$$$reportNull$$$0(3);
        }
        this.myState.ROOT_SYNC = syncSetting;
    }

    @Nullable
    public String getRecentRootPath() {
        return this.myState.RECENT_GIT_ROOT_PATH;
    }

    public void setRecentRoot(@NotNull String recentGitRootPath) {
        if (recentGitRootPath == null) {
            GitVcsSettings.$$$reportNull$$$0(4);
        }
        this.myState.RECENT_GIT_ROOT_PATH = recentGitRootPath;
    }

    @NotNull
    public Map<String, String> getRecentBranchesByRepository() {
        Map<String, String> map = this.myState.RECENT_BRANCH_BY_REPOSITORY;
        if (map == null) {
            GitVcsSettings.$$$reportNull$$$0(5);
        }
        return map;
    }

    public void setRecentBranchOfRepository(@NotNull String repositoryPath, @NotNull String branch) {
        if (repositoryPath == null) {
            GitVcsSettings.$$$reportNull$$$0(6);
        }
        if (branch == null) {
            GitVcsSettings.$$$reportNull$$$0(7);
        }
        this.myState.RECENT_BRANCH_BY_REPOSITORY.put(repositoryPath, branch);
    }

    @Nullable
    public String getRecentCommonBranch() {
        return this.myState.RECENT_COMMON_BRANCH;
    }

    public void setRecentCommonBranch(@NotNull String branch) {
        if (branch == null) {
            GitVcsSettings.$$$reportNull$$$0(8);
        }
        this.myState.RECENT_COMMON_BRANCH = branch;
    }

    public void setAutoCommitOnCherryPick(boolean autoCommit) {
        this.myState.AUTO_COMMIT_ON_CHERRY_PICK = autoCommit;
    }

    public boolean isAutoCommitOnCherryPick() {
        return this.myState.AUTO_COMMIT_ON_CHERRY_PICK;
    }

    public void setAutoCommitOnRevert(boolean autoCommit) {
        this.myState.AUTO_COMMIT_ON_REVERT = autoCommit;
    }

    public boolean isAutoCommitOnRevert() {
        return this.myState.AUTO_COMMIT_ON_REVERT;
    }

    public boolean warnAboutCrlf() {
        return this.myState.WARN_ABOUT_CRLF;
    }

    public void setWarnAboutCrlf(boolean warn) {
        this.myState.WARN_ABOUT_CRLF = warn;
    }

    public boolean warnAboutDetachedHead() {
        return this.myState.WARN_ABOUT_DETACHED_HEAD;
    }

    public void setWarnAboutDetachedHead(boolean warn) {
        this.myState.WARN_ABOUT_DETACHED_HEAD = warn;
    }

    @Nullable
    public GitResetMode getResetMode() {
        return this.myState.RESET_MODE;
    }

    public void setResetMode(@NotNull GitResetMode mode) {
        if (mode == null) {
            GitVcsSettings.$$$reportNull$$$0(9);
        }
        this.myState.RESET_MODE = mode;
    }

    public boolean isForcePushAllowed() {
        return this.myState.FORCE_PUSH_ALLOWED;
    }

    public void setForcePushAllowed(boolean allowed) {
        this.myState.FORCE_PUSH_ALLOWED = allowed;
    }

    @Nullable
    public GitPushTagMode getPushTagMode() {
        return this.myState.PUSH_TAGS;
    }

    public void setPushTagMode(@Nullable GitPushTagMode mode) {
        this.myState.PUSH_TAGS = mode;
    }

    public boolean shouldSignOffCommit() {
        return this.myState.SIGN_OFF_COMMIT;
    }

    public void setSignOffCommit(boolean state) {
        this.myState.SIGN_OFF_COMMIT = state;
    }

    @Deprecated
    public boolean isIdeaSsh() {
        if (this.getAppSettings().getIdeaSsh() == null) {
            this.getAppSettings().setIdeaSsh(this.myState.SSH_EXECUTABLE);
        }
        return this.getAppSettings().getIdeaSsh() == GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
    }

    @Nullable
    public GitRemoteBranch getPushTarget(@NotNull GitRepository repository, @NotNull String sourceBranch) {
        PushTargetInfo targetInfo;
        if (repository == null) {
            GitVcsSettings.$$$reportNull$$$0(10);
        }
        if (sourceBranch == null) {
            GitVcsSettings.$$$reportNull$$$0(11);
        }
        if ((targetInfo = (PushTargetInfo)DvcsBranchUtil.find(this.myState.PUSH_TARGETS, (Repository)repository, (String)sourceBranch)) == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, targetInfo.targetRemoteName);
        if (remote == null) {
            return null;
        }
        return GitUtil.findOrCreateRemoteBranch(repository, remote, targetInfo.targetBranchName);
    }

    public void setPushTarget(@NotNull GitRepository repository, @NotNull String sourceBranch, @NotNull String targetRemote, @NotNull String targetBranch) {
        if (repository == null) {
            GitVcsSettings.$$$reportNull$$$0(12);
        }
        if (sourceBranch == null) {
            GitVcsSettings.$$$reportNull$$$0(13);
        }
        if (targetRemote == null) {
            GitVcsSettings.$$$reportNull$$$0(14);
        }
        if (targetBranch == null) {
            GitVcsSettings.$$$reportNull$$$0(15);
        }
        String repositoryPath = repository.getRoot().getPath();
        PushTargetInfo existingInfo = (PushTargetInfo)DvcsBranchUtil.find(this.myState.PUSH_TARGETS, (Repository)repository, (String)sourceBranch);
        if (existingInfo != null) {
            this.myState.PUSH_TARGETS.remove((Object)existingInfo);
        }
        this.myState.PUSH_TARGETS.add(new PushTargetInfo(repositoryPath, sourceBranch, targetRemote, targetBranch));
    }

    @NotNull
    public DvcsBranchSettings getFavoriteBranchSettings() {
        DvcsBranchSettings dvcsBranchSettings = this.myState.FAVORITE_BRANCH_SETTINGS;
        if (dvcsBranchSettings == null) {
            GitVcsSettings.$$$reportNull$$$0(16);
        }
        return dvcsBranchSettings;
    }

    public boolean shouldSetUserNameGlobally() {
        return this.myState.SET_USER_NAME_GLOBALLY;
    }

    public void setUserNameGlobally(boolean value) {
        this.myState.SET_USER_NAME_GLOBALLY = value;
    }

    public boolean shouldSwapSidesInCompareBranches() {
        return this.myState.SWAP_SIDES_IN_COMPARE_BRANCHES;
    }

    public void setSwapSidesInCompareBranches(boolean value) {
        this.myState.SWAP_SIDES_IN_COMPARE_BRANCHES = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitVcsSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncSetting";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentGitRootPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBranch";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRemote";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "updateChangesPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncSetting";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitVcsSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentBranchesByRepository";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteBranchSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSyncSetting";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRecentRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setRecentBranchOfRepository";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setRecentCommonBranch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setResetMode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPushTarget";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setPushTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="push-target-info")
    private static class PushTargetInfo
    extends DvcsBranchInfo {
        @Attribute(value="target-remote")
        public String targetRemoteName;
        @Attribute(value="target-branch")
        public String targetBranchName;

        public PushTargetInfo() {
            this("", "", "", "");
        }

        PushTargetInfo(@NotNull String repositoryPath, @NotNull String source, @NotNull String targetRemote, @NotNull String targetBranch) {
            if (repositoryPath == null) {
                PushTargetInfo.$$$reportNull$$$0(0);
            }
            if (source == null) {
                PushTargetInfo.$$$reportNull$$$0(1);
            }
            if (targetRemote == null) {
                PushTargetInfo.$$$reportNull$$$0(2);
            }
            if (targetBranch == null) {
                PushTargetInfo.$$$reportNull$$$0(3);
            }
            super(repositoryPath, source);
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PushTargetInfo info = (PushTargetInfo)((Object)o);
            if (this.targetRemoteName != null ? !this.targetRemoteName.equals(info.targetRemoteName) : info.targetRemoteName != null) {
                return false;
            }
            return !(this.targetBranchName != null ? !this.targetBranchName.equals(info.targetBranchName) : info.targetBranchName != null);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.targetRemoteName, this.targetBranchName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetRemote";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetBranch";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/GitVcsSettings$PushTargetInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        public List<String> PREVIOUS_COMMIT_AUTHORS = new ArrayList<String>();
        public GitVcsApplicationSettings.SshExecutable SSH_EXECUTABLE = GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
        public UpdateChangesPolicy UPDATE_CHANGES_POLICY = UpdateChangesPolicy.STASH;
        public UpdateMethod UPDATE_TYPE = UpdateMethod.BRANCH_DEFAULT;
        public boolean PUSH_AUTO_UPDATE = false;
        public boolean PUSH_UPDATE_ALL_ROOTS = true;
        public DvcsSyncSettings.Value ROOT_SYNC = DvcsSyncSettings.Value.NOT_DECIDED;
        public String RECENT_GIT_ROOT_PATH = null;
        public Map<String, String> RECENT_BRANCH_BY_REPOSITORY = new HashMap<String, String>();
        public String RECENT_COMMON_BRANCH = null;
        public boolean AUTO_COMMIT_ON_CHERRY_PICK = false;
        public boolean AUTO_COMMIT_ON_REVERT = false;
        public boolean WARN_ABOUT_CRLF = true;
        public boolean WARN_ABOUT_DETACHED_HEAD = true;
        public GitResetMode RESET_MODE = null;
        public boolean FORCE_PUSH_ALLOWED = true;
        public GitPushTagMode PUSH_TAGS = null;
        public boolean SIGN_OFF_COMMIT = false;
        public boolean SET_USER_NAME_GLOBALLY = true;
        public boolean SWAP_SIDES_IN_COMPARE_BRANCHES = false;
        @AbstractCollection(surroundWithTag=false)
        @Tag(value="push-targets")
        public List<PushTargetInfo> PUSH_TARGETS = ContainerUtil.newArrayList();
        @Property(surroundWithTag=false, flat=true)
        public DvcsBranchSettings FAVORITE_BRANCH_SETTINGS = new DvcsBranchSettings();
    }

    public static enum UpdateChangesPolicy {
        STASH,
        SHELVE;

    }
}

