/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.ElementManipulator;
import org.jetbrains.kotlin.com.intellij.psi.ElementManipulators;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyVariantReference;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;

public abstract class PsiPolyVariantCachingReference
implements PsiPolyVariantReference {
    @Override
    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiElement element = this.getElement();
        PsiFile file = element.getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(file.getProject()).resolveWithCaching(this, MyResolver.INSTANCE, true, incompleteCode, file);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/PsiPolyVariantCachingReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Override
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @NotNull
    protected abstract ResolveResult[] resolveInner(boolean var1, @NotNull PsiFile var2);

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.getElement().getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Nullable
    public static <T extends PsiElement> ElementManipulator<T> getManipulator(T currentElement) {
        return ElementManipulators.getManipulator(currentElement);
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantContextResolver<PsiPolyVariantReference> {
        private static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiPolyVariantReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/PsiPolyVariantCachingReference$MyResolver", "resolve"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/PsiPolyVariantCachingReference$MyResolver", "resolve"));
            }
            ResolveResult[] resolveResultArray = ((PsiPolyVariantCachingReference)ref).resolveInner(incompleteCode, containingFile);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/PsiPolyVariantCachingReference$MyResolver", "resolve"));
            }
            return resolveResultArray;
        }
    }
}

