/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.testFramework;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.NonPhysicalFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.LocalTimeCounter;

public abstract class LightVirtualFileBase
extends VirtualFile {
    private FileType myFileType;
    private String myName = "";
    private long myModStamp = LocalTimeCounter.currentTime();
    private boolean myIsWritable = true;
    private boolean myValid = true;
    private VirtualFile myOriginalFile;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();

    public LightVirtualFileBase(String name, FileType fileType, long modificationStamp) {
        this.myName = name;
        this.myFileType = fileType;
        this.myModStamp = modificationStamp;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public void setOriginalFile(VirtualFile originalFile) {
        this.myOriginalFile = originalFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        MyVirtualFileSystem myVirtualFileSystem = ourFileSystem;
        if (myVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "getFileSystem"));
        }
        return myVirtualFileSystem;
    }

    @Nullable
    public FileType getAssignedFileType() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        if (this.myOriginalFile != null) {
            FileType fileType = this.myOriginalFile.getFileType();
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "getFileType"));
            }
            return fileType;
        }
        FileType fileType = super.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "getFileType"));
        }
        return fileType;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = "/" + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "getPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "getName"));
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    @Override
    public VirtualFile getParent() {
        return null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    protected void setModificationStamp(long stamp) {
        this.myModStamp = stamp;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public void setWritable(boolean b) {
        this.myIsWritable = b;
    }

    @Override
    public void rename(Object requestor, @NotNull String newName2) throws IOException {
        if (newName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "rename"));
        }
        this.assertWritable();
        this.myName = newName2;
    }

    void assertWritable() {
        if (!this.isWritable()) {
            throw new IncorrectOperationException("File is not writable: " + this);
        }
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "createChildDirectory"));
        }
        this.assertWritable();
        VirtualFile virtualFile2 = super.createChildDirectory(requestor, name);
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "createChildDirectory"));
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "createChildData"));
        }
        this.assertWritable();
        VirtualFile virtualFile2 = super.createChildData(requestor, name);
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "createChildData"));
        }
        return virtualFile2;
    }

    @Override
    public void delete(Object requestor) throws IOException {
        this.assertWritable();
        super.delete(requestor);
    }

    @Override
    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "move"));
        }
        this.assertWritable();
        super.move(requestor, newParent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long l) throws IOException {
        void newTimeStamp;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "setBinaryContent"));
        }
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, (long)newTimeStamp);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase", "setBinaryContent"));
        }
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor);
    }

    private static class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem
    implements NonPhysicalFileSystem {
        private MyVirtualFileSystem() {
            this.startEventPropagation();
        }

        @Override
        @NotNull
        public String getProtocol() {
            if ("mock" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase$MyVirtualFileSystem", "getProtocol"));
            }
            return "mock";
        }

        @Override
        @Nullable
        public VirtualFile findFileByPath(@NotNull String path2) {
            if (path2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase$MyVirtualFileSystem", "findFileByPath"));
            }
            return null;
        }

        @Override
        public void refresh(boolean asynchronous) {
        }

        @Override
        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
            if (path2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFileBase$MyVirtualFileSystem", "refreshAndFindFileByPath"));
            }
            return null;
        }
    }
}

