/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenEntry;

public class KtWhenExpression
extends KtExpressionImpl {
    public KtWhenExpression(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public List<KtWhenEntry> getEntries() {
        return this.findChildrenByType(KtNodeTypes.WHEN_ENTRY);
    }

    @Nullable
    public KtExpression getSubjectExpression() {
        return this.findChildByClass(KtExpression.class);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitWhenExpression(this, data);
    }

    @NotNull
    public PsiElement getWhenKeyword() {
        return this.findChildByType(KtTokens.WHEN_KEYWORD);
    }

    @Nullable
    public PsiElement getCloseBrace() {
        return this.findChildByType(KtTokens.RBRACE);
    }

    @Nullable
    public PsiElement getOpenBrace() {
        return this.findChildByType(KtTokens.LBRACE);
    }

    @Nullable
    public PsiElement getLeftParenthesis() {
        return this.findChildByType(KtTokens.LPAR);
    }

    @Nullable
    public PsiElement getRightParenthesis() {
        return this.findChildByType(KtTokens.RPAR);
    }

    @Nullable
    public KtExpression getElseExpression() {
        for (KtWhenEntry entry : this.getEntries()) {
            if (!entry.isElse()) continue;
            return entry.getExpression();
        }
        return null;
    }
}

