/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolver;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponeArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.components.SimpleArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.LambdaArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCollectionLiteralAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "", "callableReferenceResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;)V", "analyze", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "analyzeLambda", "lambda", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "Context", "resolution"})
public final class PostponedArgumentsAnalyzer {
    private final CallableReferenceResolver callableReferenceResolver;

    public final void analyze(@NotNull Context c, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull ResolvedAtom argument) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        ResolvedAtom resolvedAtom = argument;
        if (resolvedAtom instanceof ResolvedLambdaAtom) {
            this.analyzeLambda(c, resolutionCallbacks, (ResolvedLambdaAtom)argument);
        } else if (resolvedAtom instanceof LambdaWithTypeVariableAsExpectedTypeAtom) {
            this.analyzeLambda(c, resolutionCallbacks, PostponeArgumentsChecksKt.transformToResolvedLambda((LambdaWithTypeVariableAsExpectedTypeAtom)argument, c.getBuilder()));
        } else if (resolvedAtom instanceof ResolvedCallableReferenceAtom) {
            this.callableReferenceResolver.processCallableReferenceArgument(c.getBuilder(), (ResolvedCallableReferenceAtom)argument);
        } else {
            if (resolvedAtom instanceof ResolvedCollectionLiteralAtom) {
                String string = "Not supported";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            String string = "Unexpected resolved primitive: " + argument.getClass().getCanonicalName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeLambda(Context c, KotlinResolutionCallbacks resolutionCallbacks, ResolvedLambdaAtom lambda2) {
        void $receiver$iv$iv;
        Object it;
        UnwrappedType unwrappedType;
        Object object;
        Object object2;
        UnwrappedType unwrappedType2;
        UnwrappedType $receiver$iv$iv2;
        Iterable $receiver$iv;
        UnwrappedType unwrappedType3;
        NewTypeSubstitutor currentSubstitutor2 = c.buildCurrentSubstitutor();
        Function1<UnwrappedType, UnwrappedType> substitute$ = new Function1<UnwrappedType, UnwrappedType>(currentSubstitutor2){
            final /* synthetic */ NewTypeSubstitutor $currentSubstitutor;

            @NotNull
            public final UnwrappedType invoke(@NotNull UnwrappedType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                return this.$currentSubstitutor.safeSubstitute(type2);
            }
            {
                this.$currentSubstitutor = newTypeSubstitutor;
                super(1);
            }
        };
        UnwrappedType unwrappedType4 = lambda2.getReceiver();
        if (unwrappedType4 != null) {
            UnwrappedType unwrappedType5;
            UnwrappedType p1 = unwrappedType5 = unwrappedType4;
            unwrappedType3 = substitute$.invoke(p1);
        } else {
            unwrappedType3 = null;
        }
        UnwrappedType receiver = unwrappedType3;
        Iterable $i$a$1$unknown = $receiver$iv = (Iterable)lambda2.getParameters();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            void p1;
            Object item$iv$iv = iterator2.next();
            unwrappedType2 = (UnwrappedType)item$iv$iv;
            object2 = destination$iv$iv;
            object = substitute$.invoke((UnwrappedType)p1);
            object2.add(object);
        }
        List parameters2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = lambda2.getReturnType();
        UnwrappedType it2 = $receiver$iv$iv2;
        UnwrappedType unwrappedType6 = c.canBeProper(it2) ? $receiver$iv$iv2 : null;
        if (unwrappedType6 != null) {
            UnwrappedType p1 = $receiver$iv$iv2 = unwrappedType6;
            unwrappedType = substitute$.invoke(p1);
        } else {
            unwrappedType = null;
        }
        UnwrappedType expectedType2 = unwrappedType;
        List<SimpleKotlinCallArgument> resultArguments = resolutionCallbacks.analyzeAndGetLambdaResultArguments(lambda2.getAtom(), lambda2.isSuspend(), receiver, parameters2, expectedType2);
        Iterable $receiver$iv2 = resultArguments;
        for (Object element$iv : $receiver$iv2) {
            it = (SimpleKotlinCallArgument)element$iv;
            ConstraintSystemBuilderKt.addSubsystemForArgument(c, (KotlinCallArgument)it);
        }
        KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        Iterable $receiver$iv3 = resultArguments;
        it = $receiver$iv3;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            void it3;
            UnwrappedType unwrappedType7;
            SimpleKotlinCallArgument simpleKotlinCallArgument = (SimpleKotlinCallArgument)item$iv$iv;
            object2 = destination$iv$iv2;
            UnwrappedType unwrappedType8 = unwrappedType7 = lambda2.getReturnType();
            void var20_22 = it3;
            ConstraintSystemBuilder constraintSystemBuilder = c.getBuilder();
            UnwrappedType unwrappedType9 = substitute$.invoke((UnwrappedType)p1);
            object = SimpleArgumentsChecksKt.checkSimpleArgument(constraintSystemBuilder, (SimpleKotlinCallArgument)var20_22, unwrappedType9, diagnosticHolder, false);
            object2.add(object);
        }
        List subResolvedKtPrimitives = (List)destination$iv$iv2;
        if (resultArguments.isEmpty()) {
            void p1;
            SimpleType unitType = TypeUtilsKt.getBuiltIns(lambda2.getReturnType()).getUnitType();
            unwrappedType2 = lambda2.getReturnType();
            destination$iv$iv2 = unwrappedType2;
            object2 = c.getBuilder();
            object = substitute$.invoke((UnwrappedType)p1);
            SimpleType simpleType2 = unitType;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"unitType");
            object2.addSubtypeConstraint((UnwrappedType)object, simpleType2, new LambdaArgumentConstraintPosition(lambda2));
        }
        lambda2.setAnalyzedResults(resultArguments, subResolvedKtPrimitives, (Collection<? extends KotlinCallDiagnostic>)diagnosticHolder.getDiagnostics());
    }

    public PostponedArgumentsAnalyzer(@NotNull CallableReferenceResolver callableReferenceResolver) {
        Intrinsics.checkParameterIsNotNull((Object)callableReferenceResolver, (String)"callableReferenceResolver");
        this.callableReferenceResolver = callableReferenceResolver;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "", "addOtherSystem", "", "otherSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "buildCurrentSubstitutor", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;", "canBeProper", "", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "getBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "resolution"})
    public static interface Context {
        @NotNull
        public NewTypeSubstitutor buildCurrentSubstitutor();

        public boolean canBeProper(@NotNull UnwrappedType var1);

        public void addOtherSystem(@NotNull ConstraintStorage var1);

        @NotNull
        public ConstraintSystemBuilder getBuilder();
    }
}

