/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.vcs.VcsMapping;
import org.gradle.vcs.VcsMappings;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.internal.VcsMappingsStore;
import org.gradle.vcs.internal.VersionControlSpecFactory;

public class DefaultVcsMappings
implements VcsMappings {
    private final VcsMappingsStore vcsMappings;
    private final VersionControlSpecFactory versionControlSpecFactory;
    private final Gradle gradle;

    public DefaultVcsMappings(Instantiator instantiator, VcsMappingsStore vcsMappings, Gradle gradle) {
        this.versionControlSpecFactory = new VersionControlSpecFactory(instantiator);
        this.vcsMappings = vcsMappings;
        this.gradle = gradle;
    }

    public VcsMappings addRule(String message, Action<VcsMapping> rule) {
        this.vcsMappings.addRule((Action)new DescribedRule(message, rule), this.gradle);
        return this;
    }

    public VcsMappings withModule(String groupName, Action<VcsMapping> rule) {
        this.vcsMappings.addRule((Action)new GavFilteredRule(groupName, rule), this.gradle);
        return this;
    }

    public <T extends VersionControlSpec> T vcs(Class<T> type, Action<? super T> configuration) {
        T vcs = this.versionControlSpecFactory.create(type);
        configuration.execute(vcs);
        return vcs;
    }

    private static class GavFilteredRule
    extends DescribedRule {
        private final String groupName;

        private GavFilteredRule(String groupName, Action<VcsMapping> delegate) {
            super("filtered rule for module " + groupName, delegate);
            this.groupName = groupName;
        }

        @Override
        public void execute(VcsMapping mapping) {
            ModuleComponentSelector moduleComponentSelector;
            if (mapping.getRequested() instanceof ModuleComponentSelector && this.groupName.equals((moduleComponentSelector = (ModuleComponentSelector)Cast.uncheckedCast((Object)mapping.getRequested())).getGroup() + ":" + moduleComponentSelector.getModule())) {
                super.execute(mapping);
            }
        }
    }

    private static class DescribedRule
    implements Action<VcsMapping>,
    Describable {
        private final String displayName;
        private final Action<VcsMapping> delegate;

        private DescribedRule(String displayName, Action<VcsMapping> delegate) {
            this.displayName = displayName;
            this.delegate = delegate;
        }

        public void execute(VcsMapping vcsMapping) {
            this.delegate.execute((Object)vcsMapping);
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

