/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.deprecation.Deprecatable;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.SingleMessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingDeprecatable
implements Deprecatable {
    private final Set<String> deprecations = new HashSet<String>();

    @Override
    public void addDeprecation(String deprecation) {
        this.deprecations.add(deprecation);
    }

    @Override
    public Set<String> getDeprecations() {
        return this.deprecations;
    }

    @Override
    public void checkDeprecation() {
        String suffix = SingleMessageLogger.getDeprecationMessage();
        for (String deprecation : this.deprecations) {
            DeprecationLogger.nagUserWith((String)String.format("%s %s.", deprecation, suffix));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingDeprecatable that = (LoggingDeprecatable)o;
        return this.deprecations != null ? this.deprecations.equals(that.deprecations) : that.deprecations == null;
    }

    public int hashCode() {
        return this.deprecations != null ? this.deprecations.hashCode() : 0;
    }
}

