/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;

public interface WithEstimatedSize {
    public int estimatedSize();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Estimates {
        public static <T> int estimateSizeOf(Collection<T> collection) {
            if (Estimates.isKnownToHaveConstantTimeSizeMethod(collection)) {
                return collection.size();
            }
            if (collection instanceof WithEstimatedSize) {
                return ((WithEstimatedSize)((Object)collection)).estimatedSize();
            }
            return 10;
        }

        public static <T> boolean isKnownToHaveConstantTimeSizeMethod(Collection<T> collection) {
            Class<?> clazz = collection.getClass();
            return clazz == HashSet.class || clazz == ArrayList.class || clazz == LinkedList.class || clazz == TreeSet.class;
        }
    }
}

