/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.progress.BuildProgressLogger;

public class BuildProgressFilter
implements RootBuildLifecycleListener,
BuildListener,
TaskExecutionGraphListener,
TaskExecutionListener,
ProjectEvaluationListener {
    private Gradle rootGradle;
    private BuildProgressLogger logger;

    public BuildProgressFilter(BuildProgressLogger logger) {
        this.logger = logger;
    }

    public void buildStarted(Gradle gradle) {
        if (gradle.getParent() == null) {
            this.rootGradle = gradle;
            this.logger.buildStarted();
        }
    }

    public void afterStart() {
    }

    public void settingsEvaluated(Settings settings) {
    }

    public void projectsLoaded(Gradle gradle) {
        if (gradle == this.rootGradle) {
            this.logger.projectsLoaded(gradle.getRootProject().getAllprojects().size());
        }
    }

    public void graphPopulated(TaskExecutionGraph graph) {
        if (this.isRootTaskGraph(graph)) {
            this.logger.graphPopulated(graph.getAllTasks().size());
        } else {
            this.logger.nestedTaskGraphPopulated(graph.getAllTasks().size());
        }
    }

    public void beforeEvaluate(Project project) {
        if (project.getGradle() == this.rootGradle) {
            this.logger.beforeEvaluate(project.getPath());
        }
    }

    public void afterEvaluate(Project project, ProjectState state) {
        if (project.getGradle() == this.rootGradle) {
            this.logger.afterEvaluate(project.getPath());
        }
    }

    public void projectsEvaluated(Gradle gradle) {
    }

    public void beforeExecute(Task task) {
        if (task.getProject().getGradle() == this.rootGradle) {
            this.logger.beforeExecute();
        }
    }

    public void afterExecute(Task task, TaskState state) {
        if (task.getProject().getGradle() == this.rootGradle) {
            this.logger.afterExecute(state.getFailure() != null);
        } else {
            this.logger.afterNestedExecute(state.getFailure() != null);
        }
    }

    public void beforeComplete() {
        this.logger.beforeComplete();
    }

    public void buildFinished(BuildResult result) {
        if (result.getGradle() == this.rootGradle) {
            this.rootGradle = null;
        }
    }

    private boolean isRootTaskGraph(TaskExecutionGraph graph) {
        return this.rootGradle != null && graph == this.rootGradle.getTaskGraph();
    }
}

