/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.concurrent.Executor;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.process.internal.DefaultExecAction;
import org.gradle.process.internal.DefaultExecHandleBuilder;
import org.gradle.process.internal.DefaultJavaExecAction;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecFactory;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.process.internal.JavaExecHandleBuilder;

public class DefaultExecActionFactory
implements ExecFactory,
Stoppable {
    private final FileResolver fileResolver;
    private final DefaultExecutorFactory executorFactory = new DefaultExecutorFactory();
    private final Executor executor;

    public DefaultExecActionFactory(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
        this.executor = this.executorFactory.create("Exec process");
    }

    public void stop() {
        this.executorFactory.stop();
    }

    public ExecFactory forContext(FileResolver fileResolver, Instantiator instantiator) {
        return new DecoratingExecActionFactory(fileResolver, instantiator, this.executor);
    }

    public ExecAction newDecoratedExecAction() {
        throw new UnsupportedOperationException();
    }

    public ExecAction newExecAction() {
        return new DefaultExecAction(this.fileResolver, this.executor);
    }

    public JavaExecAction newDecoratedJavaExecAction() {
        throw new UnsupportedOperationException();
    }

    public JavaExecAction newJavaExecAction() {
        return new DefaultJavaExecAction(this.fileResolver, this.executor);
    }

    public ExecHandleBuilder newExec() {
        return new DefaultExecHandleBuilder(this.fileResolver, this.executor);
    }

    public JavaExecHandleBuilder newJavaExec() {
        return new JavaExecHandleBuilder(this.fileResolver, this.executor);
    }

    private static class DecoratingExecActionFactory
    implements ExecFactory {
        private final FileResolver fileResolver;
        private final Instantiator instantiator;
        private final Executor executor;

        DecoratingExecActionFactory(FileResolver fileResolver, Instantiator instantiator, Executor executor) {
            this.fileResolver = fileResolver;
            this.instantiator = instantiator;
            this.executor = executor;
        }

        public ExecFactory forContext(FileResolver fileResolver, Instantiator instantiator) {
            return new DecoratingExecActionFactory(fileResolver, instantiator, this.executor);
        }

        public ExecAction newExecAction() {
            return new DefaultExecAction(this.fileResolver, this.executor);
        }

        public JavaExecAction newJavaExecAction() {
            return new DefaultJavaExecAction(this.fileResolver, this.executor);
        }

        public ExecHandleBuilder newExec() {
            return new DefaultExecHandleBuilder(this.fileResolver, this.executor);
        }

        public JavaExecHandleBuilder newJavaExec() {
            return new JavaExecHandleBuilder(this.fileResolver, this.executor);
        }

        public ExecAction newDecoratedExecAction() {
            return (ExecAction)this.instantiator.newInstance(DefaultExecAction.class, new Object[]{this.fileResolver, this.executor});
        }

        public JavaExecAction newDecoratedJavaExecAction() {
            return (JavaExecAction)this.instantiator.newInstance(DefaultJavaExecAction.class, new Object[]{this.fileResolver, this.executor});
        }
    }
}

