/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import org.gradle.api.Namer;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.internal.AbstractValidatingNamedDomainObjectContainer;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfiguration;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.PublishArtifactNotationParserFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationComponentMetaDataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.DefaultRootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Factory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.vcs.internal.VcsMappingsStore;

public class DefaultConfigurationContainer
extends AbstractValidatingNamedDomainObjectContainer<Configuration>
implements ConfigurationContainerInternal,
ConfigurationsProvider {
    public static final String DETACHED_CONFIGURATION_DEFAULT_NAME = "detachedConfiguration";
    private final ConfigurationResolver resolver;
    private final Instantiator instantiator;
    private final DomainObjectContext context;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final ProjectAccessListener projectAccessListener;
    private final ProjectFinder projectFinder;
    private final FileCollectionFactory fileCollectionFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final ImmutableAttributesFactory attributesFactory;
    private int detachedConfigurationDefaultNameCounter = 1;
    private final Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private final DefaultRootComponentMetadataBuilder rootComponentMetadataBuilder;

    public DefaultConfigurationContainer(ConfigurationResolver resolver, final Instantiator instantiator, DomainObjectContext context, ListenerManager listenerManager, DependencyMetaDataProvider dependencyMetaDataProvider, ProjectAccessListener projectAccessListener, ProjectFinder projectFinder, ConfigurationComponentMetaDataBuilder configurationComponentMetaDataBuilder, FileCollectionFactory fileCollectionFactory, final DependencySubstitutionRules globalDependencySubstitutionRules, final VcsMappingsStore vcsMappingsStore, final ComponentIdentifierFactory componentIdentifierFactory, BuildOperationExecutor buildOperationExecutor, TaskResolver taskResolver, ImmutableAttributesFactory attributesFactory, final ImmutableModuleIdentifierFactory moduleIdentifierFactory, final ComponentSelectorConverter componentSelectorConverter) {
        super(Configuration.class, instantiator, (Namer)new Configuration.Namer());
        this.resolver = resolver;
        this.instantiator = instantiator;
        this.context = context;
        this.listenerManager = listenerManager;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.projectAccessListener = projectAccessListener;
        this.projectFinder = projectFinder;
        this.fileCollectionFactory = fileCollectionFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.artifactNotationParser = new PublishArtifactNotationParserFactory(instantiator, dependencyMetaDataProvider, taskResolver).create();
        this.attributesFactory = attributesFactory;
        this.resolutionStrategyFactory = new Factory<ResolutionStrategyInternal>(){

            public ResolutionStrategyInternal create() {
                return (ResolutionStrategyInternal)instantiator.newInstance(DefaultResolutionStrategy.class, new Object[]{globalDependencySubstitutionRules, vcsMappingsStore, componentIdentifierFactory, moduleIdentifierFactory, componentSelectorConverter});
            }
        };
        this.rootComponentMetadataBuilder = new DefaultRootComponentMetadataBuilder(dependencyMetaDataProvider, componentIdentifierFactory, moduleIdentifierFactory, projectFinder, configurationComponentMetaDataBuilder, this);
    }

    protected Configuration doCreate(String name) {
        DefaultConfiguration configuration = (DefaultConfiguration)this.instantiator.newInstance(DefaultConfiguration.class, new Object[]{this.context, name, this, this.resolver, this.listenerManager, this.dependencyMetaDataProvider, this.resolutionStrategyFactory, this.projectAccessListener, this.projectFinder, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.attributesFactory, this.rootComponentMetadataBuilder});
        configuration.addMutationValidator(this.rootComponentMetadataBuilder.getValidator());
        return configuration;
    }

    @Override
    public Set<? extends ConfigurationInternal> getAll() {
        return this.withType(ConfigurationInternal.class);
    }

    @Override
    public ConfigurationInternal getByName(String name) {
        return (ConfigurationInternal)super.getByName(name);
    }

    public String getTypeDisplayName() {
        return "configuration";
    }

    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownConfigurationException(String.format("Configuration with name '%s' not found.", name));
    }

    @Override
    public ConfigurationInternal detachedConfiguration(Dependency ... dependencies) {
        String name = DETACHED_CONFIGURATION_DEFAULT_NAME + this.detachedConfigurationDefaultNameCounter++;
        DetachedConfigurationsProvider detachedConfigurationsProvider = new DetachedConfigurationsProvider();
        DefaultConfiguration detachedConfiguration = (DefaultConfiguration)this.instantiator.newInstance(DefaultConfiguration.class, new Object[]{this.context, name, detachedConfigurationsProvider, this.resolver, this.listenerManager, this.dependencyMetaDataProvider, this.resolutionStrategyFactory, this.projectAccessListener, this.projectFinder, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.attributesFactory, this.rootComponentMetadataBuilder.withConfigurationsProvider(detachedConfigurationsProvider)});
        DependencySet detachedDependencies = detachedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            detachedDependencies.add((Object)dependency.copy());
        }
        detachedConfigurationsProvider.setTheOnlyConfiguration(detachedConfiguration);
        return detachedConfiguration;
    }

    public String dump() {
        StringBuilder reply = new StringBuilder();
        reply.append("Configuration of type: " + this.getTypeDisplayName());
        Set<? extends ConfigurationInternal> configs = this.getAll();
        for (Configuration configuration : configs) {
            reply.append("\n  " + configuration.toString());
        }
        return reply.toString();
    }
}

