/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import org.gradle.util.VersionNumber;

public enum CacheLayout {
    ROOT(null, "modules", 2),
    FILE_STORE(ROOT, "files", 1),
    META_DATA(ROOT, "metadata", 48),
    RESOURCES(ROOT, "resources", 1),
    TRANSFORMS(null, "transforms", 1),
    TRANSFORMS_META_DATA(TRANSFORMS, "metadata", 1),
    TRANSFORMS_STORE(TRANSFORMS, "files", 1);

    private final String name;
    private final CacheLayout parent;
    private final int version;

    private CacheLayout(CacheLayout parent, String name, int version) {
        this.parent = parent;
        this.name = name;
        this.version = version;
    }

    public VersionNumber getVersion() {
        return VersionNumber.parse((String)this.getFormattedVersion());
    }

    public String getKey() {
        StringBuilder key = new StringBuilder();
        key.append(this.name);
        key.append("-");
        key.append(this.getFormattedVersion());
        return key.toString();
    }

    public String getFormattedVersion() {
        if (this.parent == null) {
            return String.valueOf(this.version);
        }
        return this.parent.getFormattedVersion() + '.' + String.valueOf(this.version);
    }

    public File getPath(File parentDir) {
        return new File(parentDir, this.getKey());
    }
}

