/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.AbstractVersionVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;

public class VersionRangeSelector
extends AbstractVersionVersionSelector {
    private static final String OPEN_INC = "[";
    private static final String OPEN_EXC = "]";
    private static final String OPEN_EXC_MAVEN = "(";
    private static final String CLOSE_INC = "]";
    private static final String CLOSE_EXC = "[";
    private static final String CLOSE_EXC_MAVEN = ")";
    private static final String LOWER_INFINITE = "(";
    private static final String UPPER_INFINITE = ")";
    private static final String SEPARATOR = ",";
    private static final String OPEN_INC_PATTERN = "\\[";
    private static final String OPEN_EXC_PATTERN = "\\]\\(";
    private static final String CLOSE_INC_PATTERN = "\\]";
    private static final String CLOSE_EXC_PATTERN = "\\[\\)";
    private static final String LI_PATTERN = "\\(";
    private static final String UI_PATTERN = "\\)";
    private static final String SEP_PATTERN = "\\s*\\,\\s*";
    private static final String OPEN_PATTERN = "[\\[\\]\\(]";
    private static final String CLOSE_PATTERN = "[\\]\\[\\)]";
    private static final String ANY_NON_SPECIAL_PATTERN = "[^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]";
    private static final String FINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String LOWER_INFINITE_PATTERN = "\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String UPPER_INFINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)";
    private static final String SINGLE_VALUE_PATTERN = "\\[\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\]";
    private static final Pattern FINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern LOWER_INFINITE_RANGE = Pattern.compile("\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern UPPER_INFINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private static final Pattern SINGLE_VALUE_RANGE = Pattern.compile("\\[\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\]");
    public static final Pattern ALL_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)|" + SINGLE_VALUE_RANGE);
    private final String upperBound;
    private final Version upperBoundVersion;
    private final boolean upperInclusive;
    private final String lowerBound;
    private final boolean lowerInclusive;
    private final Version lowerBoundVersion;
    private final Comparator<Version> comparator;

    public VersionRangeSelector(String selector, Comparator<Version> comparator) {
        super(selector);
        this.comparator = comparator;
        Matcher matcher = FINITE_RANGE.matcher(selector);
        if (matcher.matches()) {
            this.lowerBound = matcher.group(1);
            this.lowerInclusive = selector.startsWith("[");
            this.upperBound = matcher.group(2);
            this.upperInclusive = selector.endsWith("]");
        } else {
            matcher = LOWER_INFINITE_RANGE.matcher(selector);
            if (matcher.matches()) {
                this.lowerBound = null;
                this.lowerInclusive = true;
                this.upperBound = matcher.group(1);
                this.upperInclusive = selector.endsWith("]");
            } else {
                matcher = UPPER_INFINITE_RANGE.matcher(selector);
                if (matcher.matches()) {
                    this.lowerBound = matcher.group(1);
                    this.lowerInclusive = selector.startsWith("[");
                    this.upperBound = null;
                    this.upperInclusive = true;
                } else {
                    matcher = SINGLE_VALUE_RANGE.matcher(selector);
                    if (matcher.matches()) {
                        this.lowerBound = matcher.group(1);
                        this.lowerInclusive = true;
                        this.upperBound = this.lowerBound;
                        this.upperInclusive = true;
                    } else {
                        throw new IllegalArgumentException("Not a version range selector: " + selector);
                    }
                }
            }
        }
        this.lowerBoundVersion = this.lowerBound == null ? null : VersionParser.INSTANCE.transform(this.lowerBound);
        this.upperBoundVersion = this.upperBound == null ? null : VersionParser.INSTANCE.transform(this.upperBound);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean requiresMetadata() {
        return false;
    }

    @Override
    public boolean matchesUniqueVersion() {
        return false;
    }

    @Override
    public boolean accept(Version candidate) {
        if (this.lowerBound != null && !this.isHigher(candidate, this.lowerBoundVersion, this.lowerInclusive)) {
            return false;
        }
        return this.upperBound == null || this.isLower(candidate, this.upperBoundVersion, this.upperInclusive);
    }

    private boolean isLower(Version version1, Version version2, boolean inclusive) {
        int result = this.comparator.compare(version1, version2);
        return result <= (inclusive ? 0 : -1);
    }

    private boolean isHigher(Version version1, Version version2, boolean inclusive) {
        int result = this.comparator.compare(version1, version2);
        return result >= (inclusive ? 0 : 1);
    }

    public String getUpperBound() {
        return this.upperBound;
    }

    public Version getUpperBoundVersion() {
        return this.upperBoundVersion;
    }

    public boolean isUpperInclusive() {
        return this.upperInclusive;
    }

    public String getLowerBound() {
        return this.lowerBound;
    }

    public boolean isLowerInclusive() {
        return this.lowerInclusive;
    }

    public Version getLowerBoundVersion() {
        return this.lowerBoundVersion;
    }

    public String toString() {
        return this.getSelector();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionRangeSelector that = (VersionRangeSelector)o;
        if (this.upperInclusive != that.upperInclusive) {
            return false;
        }
        if (this.lowerInclusive != that.lowerInclusive) {
            return false;
        }
        if (this.upperBound != null ? !this.upperBound.equals(that.upperBound) : that.upperBound != null) {
            return false;
        }
        if (this.upperBoundVersion != null ? !this.upperBoundVersion.equals(that.upperBoundVersion) : that.upperBoundVersion != null) {
            return false;
        }
        if (this.lowerBound != null ? !this.lowerBound.equals(that.lowerBound) : that.lowerBound != null) {
            return false;
        }
        if (this.lowerBoundVersion != null ? !this.lowerBoundVersion.equals(that.lowerBoundVersion) : that.lowerBoundVersion != null) {
            return false;
        }
        return this.comparator.equals(that.comparator);
    }

    @Override
    public int hashCode() {
        int result = this.upperBound != null ? this.upperBound.hashCode() : 0;
        result = 31 * result + (this.upperBoundVersion != null ? this.upperBoundVersion.hashCode() : 0);
        result = 31 * result + (this.upperInclusive ? 1 : 0);
        result = 31 * result + (this.lowerBound != null ? this.lowerBound.hashCode() : 0);
        result = 31 * result + (this.lowerInclusive ? 1 : 0);
        result = 31 * result + (this.lowerBoundVersion != null ? this.lowerBoundVersion.hashCode() : 0);
        result = 31 * result + this.comparator.hashCode();
        return result;
    }

    public VersionRangeSelector intersect(VersionRangeSelector other) {
        StringBuilder sb = new StringBuilder();
        Version lower = null;
        Version upper = null;
        boolean lowerInc = false;
        if (this.lowerBound == null) {
            if (other.lowerBound == null) {
                sb.append("(");
            } else {
                sb.append(other.lowerInclusive ? "[" : "]");
                sb.append(other.lowerBound);
                lower = other.lowerBoundVersion;
                lowerInc = other.lowerInclusive;
            }
        } else if (other.lowerBound == null || this.isHigher(this.lowerBoundVersion, other.lowerBoundVersion, this.lowerInclusive)) {
            lowerInc = this.lowerBound.equals(other.lowerBound) ? this.lowerInclusive && other.lowerInclusive : this.lowerInclusive;
            sb.append(lowerInc ? "[" : "]");
            sb.append(this.lowerBound);
            lower = this.lowerBoundVersion;
        } else {
            lowerInc = other.lowerBound.equals(this.lowerBound) ? this.lowerInclusive && other.lowerInclusive : other.lowerInclusive;
            sb.append(lowerInc ? "[" : "]");
            sb.append(other.lowerBound);
            lower = other.lowerBoundVersion;
            lowerInc = other.lowerInclusive;
        }
        sb.append(SEPARATOR);
        if (this.upperBound == null) {
            if (other.upperBound == null) {
                sb.append(")");
            } else {
                sb.append(other.upperBound);
                sb.append(other.upperInclusive ? "]" : "[");
                upper = other.upperBoundVersion;
            }
        } else if (other.upperBound == null || this.isLower(this.upperBoundVersion, other.upperBoundVersion, this.upperInclusive)) {
            sb.append(this.upperBound);
            boolean inclusive = this.upperBound.equals(other.upperBound) ? this.upperInclusive && other.upperInclusive : this.upperInclusive;
            sb.append(inclusive ? "]" : "[");
            upper = this.upperBoundVersion;
        } else {
            sb.append(other.upperBound);
            boolean inclusive = other.upperBound.equals(this.upperBound) ? this.upperInclusive && other.upperInclusive : other.upperInclusive;
            sb.append(inclusive ? "]" : "[");
            upper = other.upperBoundVersion;
        }
        if (lower != null && upper != null && this.isHigher(lower, upper, lowerInc)) {
            return null;
        }
        if (lower != null && lower.equals(upper) && !lowerInc) {
            return null;
        }
        return new VersionRangeSelector(sb.toString(), this.comparator);
    }
}

