/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.AmbiguousTransformException;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedResolvedVariant;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Pair;
import org.gradle.internal.component.AmbiguousVariantSelectionException;
import org.gradle.internal.component.NoMatchingVariantSelectionException;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;

class AttributeMatchingVariantSelector
implements VariantSelector {
    private final ConsumerProvidedVariantFinder consumerProvidedVariantFinder;
    private final AttributesSchemaInternal schema;
    private final AttributeContainerInternal requested;
    private final boolean ignoreWhenNoMatches;

    AttributeMatchingVariantSelector(ConsumerProvidedVariantFinder consumerProvidedVariantFinder, AttributesSchemaInternal schema, AttributeContainerInternal requested, boolean ignoreWhenNoMatches) {
        this.consumerProvidedVariantFinder = consumerProvidedVariantFinder;
        this.schema = schema;
        this.requested = requested;
        this.ignoreWhenNoMatches = ignoreWhenNoMatches;
    }

    public String toString() {
        return "Variant selector for " + this.requested;
    }

    @Override
    public ResolvedArtifactSet select(ResolvedVariantSet producer) {
        try {
            return this.doSelect(producer);
        }
        catch (VariantSelectionException t) {
            return new BrokenResolvedArtifactSet(t);
        }
        catch (Throwable t) {
            return new BrokenResolvedArtifactSet(VariantSelectionException.selectionFailed(producer, t));
        }
    }

    private ResolvedArtifactSet doSelect(ResolvedVariantSet producer) {
        AttributeMatcher matcher = this.schema.withProducer(producer.getSchema());
        List<ResolvedVariant> matches = matcher.matches(producer.getVariants(), this.requested);
        if (matches.size() == 1) {
            return matches.get(0).getArtifacts();
        }
        if (matches.size() > 1) {
            throw new AmbiguousVariantSelectionException(producer.asDescribable().getDisplayName(), this.requested, matches, matcher);
        }
        ArrayList<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates = new ArrayList<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>>();
        for (ResolvedVariant variant : producer.getVariants()) {
            ImmutableAttributes variantAttributes = variant.getAttributes().asImmutable();
            ConsumerVariantMatchResult matchResult = new ConsumerVariantMatchResult();
            this.consumerProvidedVariantFinder.collectConsumerVariants((AttributeContainerInternal)variantAttributes, this.requested, matchResult);
            for (ConsumerVariantMatchResult.ConsumerVariant consumerVariant : matchResult.getMatches()) {
                candidates.add((Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>)Pair.of((Object)variant, (Object)consumerVariant));
            }
        }
        if (candidates.size() == 1) {
            Pair result = (Pair)candidates.get(0);
            return new ConsumerProvidedResolvedVariant(((ResolvedVariant)result.getLeft()).getArtifacts(), ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).attributes, ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).transformer);
        }
        if (!candidates.isEmpty()) {
            throw new AmbiguousTransformException(producer.asDescribable().getDisplayName(), this.requested, candidates);
        }
        if (this.ignoreWhenNoMatches) {
            return ResolvedArtifactSet.EMPTY;
        }
        throw new NoMatchingVariantSelectionException(producer.asDescribable().getDisplayName(), this.requested, producer.getVariants(), matcher);
    }
}

