/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.AbstractWindowsKitComponentLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.Ucrt;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.UcrtLocator;
import org.gradle.util.VersionNumber;

public class DefaultUcrtLocator
extends AbstractWindowsKitComponentLocator<Ucrt>
implements UcrtLocator {
    private static final String DISPLAY_NAME = "Universal C Runtime";
    private static final String COMPONENT_NAME = "ucrt";

    public DefaultUcrtLocator(WindowsRegistry windowsRegistry) {
        super(windowsRegistry);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    boolean isValidComponentBaseDir(File baseDir) {
        return true;
    }

    @Override
    boolean isValidComponentIncludeDir(File includeDir) {
        return new File(includeDir, "io.h").exists();
    }

    @Override
    boolean isValidComponentLibDir(File libDir) {
        for (String platform : PLATFORMS) {
            if (new File(libDir, platform + "/libucrt.lib").exists()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Ucrt newComponent(File baseDir, VersionNumber version, AbstractWindowsKitComponentLocator.DiscoveryType discoveryType) {
        return new Ucrt(baseDir, version, this.getVersionedDisplayName(version, discoveryType));
    }
}

