/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.AttributeBin;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.ShaderBin;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TextureBin;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencySortGeom;

class TransparentRenderingInfo
implements TransparencySortGeom {
    RenderMolecule rm;
    RenderAtomListInfo rInfo;
    TransparentRenderingInfo prev;
    TransparentRenderingInfo next;
    GeometryAtom geometryAtom;
    double zVal;

    TransparentRenderingInfo() {
    }

    boolean updateState(Canvas3D canvas3D) {
        TextureBin textureBin = this.rm.textureBin;
        AttributeBin attributeBin = textureBin.attributeBin;
        ShaderBin shaderBin = textureBin.shaderBin;
        RenderMolecule renderMolecule = textureBin.transparentRMList;
        while (renderMolecule != null && !renderMolecule.isSwitchOn()) {
            if (renderMolecule.next != null) {
                renderMolecule = renderMolecule.next;
                continue;
            }
            renderMolecule = renderMolecule.nextMap;
        }
        if (renderMolecule == null) {
            return false;
        }
        if (canvas3D.environmentSet != attributeBin.environmentSet) {
            boolean bl;
            boolean bl2 = bl = attributeBin.definingRenderingAttributes == null || attributeBin.definingRenderingAttributes.visible;
            if (attributeBin.environmentSet.renderBin.view.viewCache.visibilityPolicy == 0 && !bl || attributeBin.environmentSet.renderBin.view.viewCache.visibilityPolicy == 1 && bl) {
                return false;
            }
            canvas3D.setStateToUpdate(0, attributeBin.environmentSet.lightBin);
            canvas3D.setStateToUpdate(1, attributeBin.environmentSet);
            canvas3D.setStateToUpdate(2, attributeBin);
            canvas3D.setStateToUpdate(6, shaderBin);
            canvas3D.updateEnvState();
        } else if (canvas3D.attributeBin != attributeBin) {
            boolean bl;
            boolean bl3 = bl = attributeBin.definingRenderingAttributes == null || attributeBin.definingRenderingAttributes.visible;
            if (attributeBin.environmentSet.renderBin.view.viewCache.visibilityPolicy == 0 && !bl || attributeBin.environmentSet.renderBin.view.viewCache.visibilityPolicy == 1 && bl) {
                return false;
            }
            canvas3D.setStateToUpdate(2, attributeBin);
            canvas3D.setStateToUpdate(6, shaderBin);
            canvas3D.updateEnvState();
        } else if (canvas3D.shaderBin != shaderBin) {
            canvas3D.setStateToUpdate(6, shaderBin);
            canvas3D.updateEnvState();
        }
        return true;
    }

    void render(Canvas3D canvas3D) {
        if (this.updateState(canvas3D)) {
            this.rm.textureBin.render(canvas3D, this.rm.textureBin.transparentRMList);
        }
    }

    void sortRender(Canvas3D canvas3D) {
        if (this.updateState(canvas3D)) {
            this.rm.textureBin.render(canvas3D, this);
        }
    }

    public double getDistanceSquared() {
        return this.zVal;
    }

    public Geometry getGeometry() {
        if (this.geometryAtom.geometryArray[0] == null) {
            return null;
        }
        return (Geometry)this.geometryAtom.geometryArray[0].source;
    }

    public void getLocalToVWorld(Transform3D transform3D) {
        transform3D.set(this.rm.localToVworld[0]);
    }

    public Shape3D getShape3D() {
        return (Shape3D)this.geometryAtom.source.source;
    }
}

