#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: Agda
version: 2.5.3
id: Agda-2.5.3-8tKNdk5GSzKFz7TuCn8Y7L
key: Agda-2.5.3-8tKNdk5GSzKFz7TuCn8Y7L
license: OtherLicense
maintainer: Ulf Norell <ulfn@chalmers.se>
homepage: http://wiki.portal.chalmers.se/agda/
synopsis: A dependently typed functional programming language and proof assistant
description:
    Agda is a dependently typed functional programming language: It has
    inductive families, which are similar to Haskell'\''s GADTs, but they
    can be indexed by values and not just types. It also has
    parameterised modules, mixfix operators, Unicode characters, and an
    interactive Emacs interface (the type checker can assist in the
    development of your code).
    .
    Agda is also a proof assistant: It is an interactive system for
    writing and checking proofs. Agda is based on intuitionistic type
    theory, a foundational system for constructive mathematics developed
    by the Swedish logician Per Martin-L&#xf6;f. It has many
    similarities with other proof assistants based on dependent types,
    such as Coq, Epigram and NuPRL.
    .
    This package includes both a command-line program (agda) and an
    Emacs mode. If you want to use the Emacs mode you can set it up by
    running @agda-mode setup@ (see the README).
    .
    Note that the Agda package does not follow the package versioning
    policy, because it is not intended to be used by third-party
    packages.
category: Dependent types
author: Agda 2 was originally written by Ulf Norell, partially based on code from Agda 1 by Catarina Coquand and Makoto Takeyama, and from Agdalight by Ulf Norell and Andreas Abel. Agda 2 is currently actively developed mainly by Andreas Abel, Guillaume Allais, Jesper Cockx, Nils Anders Danielsson, Philipp Hausmann, Fredrik Nordvall Forsberg, Ulf Norell, Víctor López Juan, Andrés Sicard-Ramírez, and Andrea Vezzosi. Further, Agda 2 has received contributions by, amongst others, Stevan Andjelkovic, Marcin Benke, Jean-Philippe Bernardy, Guillaume Brunerie, James Chapman, Dominique Devriese, Péter Diviánszki, Olle Fredriksson, Adam Gundry, Daniel Gustafsson, Kuen-Bang Hou (favonia), Patrik Jansson, Alan Jeffrey, Wolfram Kahl, Pepijn Kokke, Fredrik Lindblad, Francesco Mazzoli, Stefan Monnier, Darin Morrison, Guilhem Moulin, Nicolas Pouillard, Nobuo Yamashita, Christian Sattler, and Makoto Takeyama and many more.
exposed: True
indefinite: False
exposed-modules:
    Agda.Auto.Auto Agda.Auto.CaseSplit Agda.Auto.Convert
    Agda.Auto.NarrowingSearch Agda.Auto.Options Agda.Auto.SearchControl
    Agda.Auto.Syntax Agda.Auto.Typecheck Agda.Benchmarking
    Agda.Compiler.Backend Agda.Compiler.CallCompiler
    Agda.Compiler.Common Agda.Compiler.JS.Compiler
    Agda.Compiler.JS.Pretty Agda.Compiler.JS.Substitution
    Agda.Compiler.JS.Syntax Agda.Compiler.MAlonzo.Compiler
    Agda.Compiler.MAlonzo.Encode Agda.Compiler.MAlonzo.HaskellTypes
    Agda.Compiler.MAlonzo.Misc Agda.Compiler.MAlonzo.Pragmas
    Agda.Compiler.MAlonzo.Pretty Agda.Compiler.MAlonzo.Primitives
    Agda.Compiler.ToTreeless Agda.Compiler.Treeless.AsPatterns
    Agda.Compiler.Treeless.Builtin Agda.Compiler.Treeless.Compare
    Agda.Compiler.Treeless.EliminateDefaults
    Agda.Compiler.Treeless.EliminateLiteralPatterns
    Agda.Compiler.Treeless.Erase Agda.Compiler.Treeless.GuardsToPrims
    Agda.Compiler.Treeless.Identity
    Agda.Compiler.Treeless.NormalizeNames Agda.Compiler.Treeless.Pretty
    Agda.Compiler.Treeless.Simplify Agda.Compiler.Treeless.Subst
    Agda.Compiler.Treeless.Uncase Agda.Compiler.Treeless.Unused
    Agda.ImpossibleTest Agda.Interaction.BasicOps
    Agda.Interaction.CommandLine Agda.Interaction.EmacsCommand
    Agda.Interaction.EmacsTop Agda.Interaction.FindFile
    Agda.Interaction.Highlighting.Dot
    Agda.Interaction.Highlighting.Emacs
    Agda.Interaction.Highlighting.Generate
    Agda.Interaction.Highlighting.HTML
    Agda.Interaction.Highlighting.LaTeX
    Agda.Interaction.Highlighting.Precise
    Agda.Interaction.Highlighting.Range
    Agda.Interaction.Highlighting.Vim Agda.Interaction.Imports
    Agda.Interaction.InteractionTop Agda.Interaction.Library
    Agda.Interaction.Library.Base Agda.Interaction.Library.Parse
    Agda.Interaction.MakeCase Agda.Interaction.Monad
    Agda.Interaction.Options Agda.Interaction.Options.Lenses
    Agda.Interaction.Response Agda.Interaction.SearchAbout Agda.Main
    Agda.Syntax.Abstract Agda.Syntax.Abstract.Copatterns
    Agda.Syntax.Abstract.Name Agda.Syntax.Abstract.Pattern
    Agda.Syntax.Abstract.Pretty Agda.Syntax.Abstract.Views
    Agda.Syntax.Common Agda.Syntax.Concrete
    Agda.Syntax.Concrete.Definitions Agda.Syntax.Concrete.Generic
    Agda.Syntax.Concrete.Name Agda.Syntax.Concrete.Operators
    Agda.Syntax.Concrete.Operators.Parser
    Agda.Syntax.Concrete.Operators.Parser.Monad
    Agda.Syntax.Concrete.Pretty Agda.Syntax.Fixity
    Agda.Syntax.IdiomBrackets Agda.Syntax.Info Agda.Syntax.Internal
    Agda.Syntax.Internal.Defs Agda.Syntax.Internal.Generic
    Agda.Syntax.Internal.Names Agda.Syntax.Internal.Pattern
    Agda.Syntax.Internal.SanityCheck Agda.Syntax.Literal
    Agda.Syntax.Notation Agda.Syntax.Parser Agda.Syntax.Parser.Alex
    Agda.Syntax.Parser.Comments Agda.Syntax.Parser.Layout
    Agda.Syntax.Parser.LexActions Agda.Syntax.Parser.Lexer
    Agda.Syntax.Parser.Literate Agda.Syntax.Parser.LookAhead
    Agda.Syntax.Parser.Monad Agda.Syntax.Parser.Parser
    Agda.Syntax.Parser.StringLiterals Agda.Syntax.Parser.Tokens
    Agda.Syntax.Position Agda.Syntax.Reflected Agda.Syntax.Scope.Base
    Agda.Syntax.Scope.Monad Agda.Syntax.Translation.AbstractToConcrete
    Agda.Syntax.Translation.ConcreteToAbstract
    Agda.Syntax.Translation.InternalToAbstract
    Agda.Syntax.Translation.ReflectedToAbstract Agda.Syntax.Treeless
    Agda.Termination.CallGraph Agda.Termination.CallMatrix
    Agda.Termination.CutOff Agda.Termination.Inlining
    Agda.Termination.Monad Agda.Termination.Order
    Agda.Termination.RecCheck Agda.Termination.Semiring
    Agda.Termination.SparseMatrix Agda.Termination.TermCheck
    Agda.Termination.Termination Agda.TheTypeChecker
    Agda.TypeChecking.Abstract Agda.TypeChecking.CheckInternal
    Agda.TypeChecking.CompiledClause
    Agda.TypeChecking.CompiledClause.Compile
    Agda.TypeChecking.CompiledClause.Match
    Agda.TypeChecking.Constraints Agda.TypeChecking.Conversion
    Agda.TypeChecking.Coverage Agda.TypeChecking.Coverage.Match
    Agda.TypeChecking.Coverage.SplitTree Agda.TypeChecking.Datatypes
    Agda.TypeChecking.DeadCode Agda.TypeChecking.DisplayForm
    Agda.TypeChecking.DropArgs Agda.TypeChecking.Empty
    Agda.TypeChecking.Errors Agda.TypeChecking.EtaContract
    Agda.TypeChecking.Forcing Agda.TypeChecking.Free
    Agda.TypeChecking.Free.Lazy Agda.TypeChecking.Free.Old
    Agda.TypeChecking.Functions Agda.TypeChecking.Implicit
    Agda.TypeChecking.Injectivity Agda.TypeChecking.InstanceArguments
    Agda.TypeChecking.Irrelevance Agda.TypeChecking.Level
    Agda.TypeChecking.LevelConstraints Agda.TypeChecking.MetaVars
    Agda.TypeChecking.MetaVars.Mention
    Agda.TypeChecking.MetaVars.Occurs Agda.TypeChecking.Monad
    Agda.TypeChecking.Monad.Base Agda.TypeChecking.Monad.Benchmark
    Agda.TypeChecking.Monad.Builtin Agda.TypeChecking.Monad.Caching
    Agda.TypeChecking.Monad.Closure Agda.TypeChecking.Monad.Constraints
    Agda.TypeChecking.Monad.Context Agda.TypeChecking.Monad.Debug
    Agda.TypeChecking.Monad.Env Agda.TypeChecking.Monad.Imports
    Agda.TypeChecking.Monad.Local Agda.TypeChecking.Monad.MetaVars
    Agda.TypeChecking.Monad.Mutual Agda.TypeChecking.Monad.Open
    Agda.TypeChecking.Monad.Options Agda.TypeChecking.Monad.Sharing
    Agda.TypeChecking.Monad.Signature
    Agda.TypeChecking.Monad.SizedTypes Agda.TypeChecking.Monad.State
    Agda.TypeChecking.Monad.Statistics Agda.TypeChecking.Monad.Trace
    Agda.TypeChecking.Patterns.Abstract
    Agda.TypeChecking.Patterns.Match Agda.TypeChecking.Polarity
    Agda.TypeChecking.Positivity
    Agda.TypeChecking.Positivity.Occurrence Agda.TypeChecking.Pretty
    Agda.TypeChecking.Primitive Agda.TypeChecking.ProjectionLike
    Agda.TypeChecking.Quote Agda.TypeChecking.ReconstructParameters
    Agda.TypeChecking.RecordPatterns Agda.TypeChecking.Records
    Agda.TypeChecking.Reduce Agda.TypeChecking.Reduce.Fast
    Agda.TypeChecking.Reduce.Monad Agda.TypeChecking.Rewriting
    Agda.TypeChecking.Rewriting.NonLinMatch
    Agda.TypeChecking.Rules.Builtin
    Agda.TypeChecking.Rules.Builtin.Coinduction
    Agda.TypeChecking.Rules.Data Agda.TypeChecking.Rules.Decl
    Agda.TypeChecking.Rules.Def Agda.TypeChecking.Rules.Display
    Agda.TypeChecking.Rules.LHS Agda.TypeChecking.Rules.LHS.AsPatterns
    Agda.TypeChecking.Rules.LHS.Implicit
    Agda.TypeChecking.Rules.LHS.Instantiate
    Agda.TypeChecking.Rules.LHS.Problem
    Agda.TypeChecking.Rules.LHS.ProblemRest
    Agda.TypeChecking.Rules.LHS.Split Agda.TypeChecking.Rules.LHS.Unify
    Agda.TypeChecking.Rules.Record Agda.TypeChecking.Rules.Term
    Agda.TypeChecking.Serialise Agda.TypeChecking.Serialise.Base
    Agda.TypeChecking.Serialise.Instances
    Agda.TypeChecking.Serialise.Instances.Abstract
    Agda.TypeChecking.Serialise.Instances.Common
    Agda.TypeChecking.Serialise.Instances.Compilers
    Agda.TypeChecking.Serialise.Instances.Errors
    Agda.TypeChecking.Serialise.Instances.Highlighting
    Agda.TypeChecking.Serialise.Instances.Internal
    Agda.TypeChecking.SizedTypes Agda.TypeChecking.SizedTypes.Solve
    Agda.TypeChecking.SizedTypes.Syntax
    Agda.TypeChecking.SizedTypes.Utils
    Agda.TypeChecking.SizedTypes.WarshallSolver
    Agda.TypeChecking.Substitute Agda.TypeChecking.Substitute.Class
    Agda.TypeChecking.Substitute.DeBruijn
    Agda.TypeChecking.SyntacticEquality Agda.TypeChecking.Telescope
    Agda.TypeChecking.Unquote Agda.TypeChecking.Warnings
    Agda.TypeChecking.With Agda.Utils.AssocList Agda.Utils.Bag
    Agda.Utils.Benchmark Agda.Utils.BiMap Agda.Utils.Char
    Agda.Utils.Cluster Agda.Utils.Either Agda.Utils.Empty
    Agda.Utils.Environment Agda.Utils.Except Agda.Utils.Favorites
    Agda.Utils.FileName Agda.Utils.Function Agda.Utils.Functor
    Agda.Utils.Geniplate Agda.Utils.Graph.AdjacencyMap.Unidirectional
    Agda.Utils.Hash Agda.Utils.HashMap Agda.Utils.Haskell.Syntax
    Agda.Utils.IO Agda.Utils.IO.Binary Agda.Utils.IO.Directory
    Agda.Utils.IO.UTF8 Agda.Utils.IORef Agda.Utils.Impossible
    Agda.Utils.IndexedList Agda.Utils.Lens Agda.Utils.Lens.Examples
    Agda.Utils.List Agda.Utils.ListT Agda.Utils.Map Agda.Utils.Maybe
    Agda.Utils.Maybe.Strict Agda.Utils.Memo Agda.Utils.Monad
    Agda.Utils.Monoid Agda.Utils.Null Agda.Utils.Parser.MemoisedCPS
    Agda.Utils.Parser.ReadP Agda.Utils.PartialOrd
    Agda.Utils.Permutation Agda.Utils.Pointer Agda.Utils.Pretty
    Agda.Utils.SemiRing Agda.Utils.Singleton Agda.Utils.Size
    Agda.Utils.String Agda.Utils.Suffix Agda.Utils.Three
    Agda.Utils.Time Agda.Utils.Trie Agda.Utils.Tuple
    Agda.Utils.TypeLevel Agda.Utils.Update Agda.Utils.VarSet
    Agda.Utils.Warshall Agda.Version Agda.VersionCommit
hidden-modules: Paths_Agda
abi: 9d5c2ecaab689807e9ff0c3808120790
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/Agda-2.5.3
library-dirs: /usr/lib/ghc-8.2.2/site-local/Agda-2.5.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/agda
hs-libraries: HSAgda-2.5.3-8tKNdk5GSzKFz7TuCn8Y7L
depends:
    array-0.5.2.0 async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn base-4.10.1.0
    binary-0.8.5.1 blaze-html-0.9.0.1-2Wxj0X1c4OOA0Fs6NGHGGN
    boxes-0.1.4-GTivei2XcGKGBYkWCeime5 bytestring-0.10.8.2
    containers-0.5.10.2 data-hash-0.2.0.1-4l1SGnbqNHx3iulLfjA02R
    deepseq-1.4.3.0 directory-1.3.0.2
    EdisonCore-1.3.1.1-FADmCSXh3Nt8thXmDRvhLX
    edit-distance-0.2.2.1-EaSjgw2yYb066MoIbDPIEG
    equivalence-0.3.2-32ylKtvkA2OJrNAEiVz1L0 filepath-1.4.1.2
    geniplate-mirror-0.7.5-H5eWlgirj5FFwlGDJURBR6
    gitrev-1.3.1-JVrypmYNWjs1jJQPEs0aKn
    hashable-1.2.6.1-6LeHpYZ4iRgEy9P36eCQfR
    hashtables-1.2.2.1-9w5Q3O7JF3O89FBOTJu0vm haskeline-0.7.4.0
    ieee754-0.8.0-B9FdsnFZjDO5G55ttUSqU0
    monadplus-1.4.2-ELxF4feHunYLBDbGsqK8bu
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    murmur-hash-0.1.0.9-58saU5wLuI95RQk0lfaLJm
    uri-encode-1.5.0.5-5Catwi4SdqWKkVHjt2pJ5W
    parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1 pretty-1.1.3.3
    process-1.6.1.0 regex-tdfa-1.2.2-JGrSDGN9OzgIG6BjzD8Db2
    stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw
    strict-0.3.2-1XGU2LPrqRE7Qw1PnSNhY5 template-haskell-2.12.0.0
    text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj time-1.8.0.2
    transformers-0.5.2.0
    unordered-containers-0.2.8.0-YOGDwOwys3HjU5i3g27KB
    zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM
abi-depends: array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn=7d406f0044aa7af43d5b6fcf63e521db
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             blaze-html-0.9.0.1-2Wxj0X1c4OOA0Fs6NGHGGN=d4749ddd32d1bff43101b58ffdfa6b64
             boxes-0.1.4-GTivei2XcGKGBYkWCeime5=d11a81b9915e8061721a55b9810c1bc4
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             data-hash-0.2.0.1-4l1SGnbqNHx3iulLfjA02R=da4297a54266fff1d55da9b79ebf2538
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             EdisonCore-1.3.1.1-FADmCSXh3Nt8thXmDRvhLX=e27d3c5a37c0301d76cc48cd5acc2387
             edit-distance-0.2.2.1-EaSjgw2yYb066MoIbDPIEG=b97662cfc4ad907ec678952cb446113f
             equivalence-0.3.2-32ylKtvkA2OJrNAEiVz1L0=a9cbe8315423fa1dc66475e01a69d9a4
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             geniplate-mirror-0.7.5-H5eWlgirj5FFwlGDJURBR6=80462927e49658865c5ea42d596f1bdf
             gitrev-1.3.1-JVrypmYNWjs1jJQPEs0aKn=35cc1ffdc65ae4d309d3c7edeafaab25
             hashable-1.2.6.1-6LeHpYZ4iRgEy9P36eCQfR=e2c3f4e35e60b5547d3e7a8c501ca6de
             hashtables-1.2.2.1-9w5Q3O7JF3O89FBOTJu0vm=ce2cd3c8e44df51adb3f5f2efc82a01a
             haskeline-0.7.4.0=1141a9f24dba7d57fb2023df1fd20c51
             ieee754-0.8.0-B9FdsnFZjDO5G55ttUSqU0=b8bb49b8cfa609e010a6613d88ba1169
             monadplus-1.4.2-ELxF4feHunYLBDbGsqK8bu=a7ca4806e199f082bd9a230bf3999af6
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             murmur-hash-0.1.0.9-58saU5wLuI95RQk0lfaLJm=b754df507cbee4444792128a2d52a1e3
             uri-encode-1.5.0.5-5Catwi4SdqWKkVHjt2pJ5W=00dcebfa14331afdbd5a4b608fd0f9bf
             parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1=f329a0732f0d1ccfb717a7145bfd3a72
             pretty-1.1.3.3=229bcf5342145ac1755207fe83d29780
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             regex-tdfa-1.2.2-JGrSDGN9OzgIG6BjzD8Db2=1f7384d261dd3860221965b2d2274d30
             stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw=63c518eabfb1b430d925fb35cc544a7c
             strict-0.3.2-1XGU2LPrqRE7Qw1PnSNhY5=3d5fec282558d1526e02739f39548bf2
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj=b7726d921cac66adc5c8f9f66f5b25f0
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             unordered-containers-0.2.8.0-YOGDwOwys3HjU5i3g27KB=1ae4406c8abf6f6a305796d42b6e1b7b
             zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM=fc994ec0331fc01f98e1d968398a1aa2
haddock-interfaces: /usr/share/doc/agda/html/Agda.haddock
haddock-html: /usr/share/doc/agda/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

