/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheConfig;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;

public final class DfsBlockCache {
    private static volatile DfsBlockCache cache;
    private final int tableSize;
    private final AtomicReferenceArray<HashEntry> table;
    private final ReentrantLock[] loadLocks;
    private final long maxBytes;
    private final long maxStreamThroughCache;
    private final int blockSize;
    private final int blockSizeShift;
    private final AtomicLong statHit;
    private final AtomicLong statMiss;
    private volatile long statEvict;
    private final ReentrantLock clockLock;
    private Ref clockHand;
    private volatile long liveBytes;

    public static void reconfigure(DfsBlockCacheConfig cfg) {
        cache = new DfsBlockCache(cfg);
    }

    public static DfsBlockCache getInstance() {
        return cache;
    }

    private DfsBlockCache(DfsBlockCacheConfig cfg) {
        this.tableSize = DfsBlockCache.tableSize(cfg);
        if (this.tableSize < 1) {
            throw new IllegalArgumentException(JGitText.get().tSizeMustBeGreaterOrEqual1);
        }
        this.table = new AtomicReferenceArray(this.tableSize);
        this.loadLocks = new ReentrantLock[cfg.getConcurrencyLevel()];
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new ReentrantLock(true);
        }
        this.maxBytes = cfg.getBlockLimit();
        this.maxStreamThroughCache = (long)((double)this.maxBytes * cfg.getStreamRatio());
        this.blockSize = cfg.getBlockSize();
        this.blockSizeShift = Integer.numberOfTrailingZeros(this.blockSize);
        this.clockLock = new ReentrantLock(true);
        String none = "";
        this.clockHand = new Ref<Object>(DfsStreamKey.of(new DfsRepositoryDescription(none), none), -1L, 0, null);
        this.clockHand.next = this.clockHand;
        this.statHit = new AtomicLong();
        this.statMiss = new AtomicLong();
    }

    boolean shouldCopyThroughCache(long length) {
        return length <= this.maxStreamThroughCache;
    }

    public long getCurrentSize() {
        return this.liveBytes;
    }

    public long getFillPercentage() {
        return this.getCurrentSize() * 100L / this.maxBytes;
    }

    public long getHitCount() {
        return this.statHit.get();
    }

    public long getMissCount() {
        return this.statMiss.get();
    }

    public long getTotalRequestCount() {
        return this.getHitCount() + this.getMissCount();
    }

    public long getHitRatio() {
        long miss;
        long hits = this.statHit.get();
        long total = hits + (miss = this.statMiss.get());
        if (total == 0L) {
            return 0L;
        }
        return hits * 100L / total;
    }

    public long getEvictions() {
        return this.statEvict;
    }

    private int hash(int packHash, long off) {
        return packHash + (int)(off >>> this.blockSizeShift);
    }

    int getBlockSize() {
        return this.blockSize;
    }

    private static int tableSize(DfsBlockCacheConfig cfg) {
        int wsz = cfg.getBlockSize();
        long limit = cfg.getBlockLimit();
        if (wsz <= 0) {
            throw new IllegalArgumentException(JGitText.get().invalidWindowSize);
        }
        if (limit < (long)wsz) {
            throw new IllegalArgumentException(JGitText.get().windowSizeMustBeLesserThanLimit);
        }
        return (int)Math.min(5L * (limit / (long)wsz) / 2L, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfsBlock getOrLoad(BlockBasedFile file2, long position, DfsReader ctx, @Nullable ReadableChannel fileChannel) throws IOException {
        long requestedPosition = position;
        DfsStreamKey key2 = file2.key;
        int slot = this.slot(key2, position = file2.alignToBlock(position));
        HashEntry e1 = this.table.get(slot);
        DfsBlock v = (DfsBlock)this.scan(e1, key2, position);
        if (v != null && v.contains(key2, requestedPosition)) {
            ++ctx.stats.blockCacheHit;
            this.statHit.incrementAndGet();
            return v;
        }
        this.reserveSpace(this.blockSize);
        ReentrantLock regionLock = this.lockFor(key2, position);
        regionLock.lock();
        try {
            HashEntry n;
            HashEntry e2 = this.table.get(slot);
            if (e2 != e1 && (v = (DfsBlock)this.scan(e2, key2, position)) != null) {
                ++ctx.stats.blockCacheHit;
                this.statHit.incrementAndGet();
                this.creditSpace(this.blockSize);
                DfsBlock dfsBlock = v;
                return dfsBlock;
            }
            this.statMiss.incrementAndGet();
            boolean credit = true;
            try {
                v = file2.readOneBlock(requestedPosition, ctx, fileChannel);
                credit = false;
            }
            finally {
                if (credit) {
                    this.creditSpace(this.blockSize);
                }
            }
            if (position != v.start) {
                position = v.start;
                slot = this.slot(key2, position);
                e2 = this.table.get(slot);
            }
            Ref<DfsBlock> ref2 = new Ref<DfsBlock>(key2, position, v.size(), v);
            ref2.hot = true;
            while (!this.table.compareAndSet(slot, e2, n = new HashEntry(DfsBlockCache.clean(e2), ref2))) {
                e2 = this.table.get(slot);
            }
            this.addToClock(ref2, this.blockSize - v.size());
        }
        finally {
            regionLock.unlock();
        }
        if (v.contains(file2.key, requestedPosition)) {
            return v;
        }
        return this.getOrLoad(file2, requestedPosition, ctx, fileChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserveSpace(int reserve) {
        this.clockLock.lock();
        try {
            long live = this.liveBytes + (long)reserve;
            if (this.maxBytes < live) {
                Ref prev2 = this.clockHand;
                Ref hand = this.clockHand.next;
                do {
                    if (hand.hot) {
                        hand.hot = false;
                        prev2 = hand;
                        hand = hand.next;
                        continue;
                    }
                    if (prev2 == hand) break;
                    Ref dead = hand;
                    prev2.next = hand = hand.next;
                    dead.next = null;
                    dead.value = null;
                    live -= (long)dead.size;
                    ++this.statEvict;
                } while (this.maxBytes < live);
                this.clockHand = prev2;
            }
            this.liveBytes = live;
        }
        finally {
            this.clockLock.unlock();
        }
    }

    private void creditSpace(int credit) {
        this.clockLock.lock();
        this.liveBytes -= (long)credit;
        this.clockLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToClock(Ref ref2, int credit) {
        this.clockLock.lock();
        try {
            if (credit != 0) {
                this.liveBytes -= (long)credit;
            }
            Ref ptr = this.clockHand;
            ref2.next = ptr.next;
            ptr.next = ref2;
            this.clockHand = ref2;
        }
        finally {
            this.clockLock.unlock();
        }
    }

    void put(DfsBlock v) {
        this.put(v.stream, v.start, v.size(), v);
    }

    <T> Ref<T> putRef(DfsStreamKey key2, long size, T v) {
        return this.put(key2, 0L, (int)Math.min(size, Integer.MAX_VALUE), v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Ref<T> put(DfsStreamKey key2, long pos, int size, T v) {
        int slot = this.slot(key2, pos);
        HashEntry e1 = this.table.get(slot);
        Ref<T> ref2 = this.scanRef(e1, key2, pos);
        if (ref2 != null) {
            return ref2;
        }
        this.reserveSpace(size);
        ReentrantLock regionLock = this.lockFor(key2, pos);
        regionLock.lock();
        try {
            HashEntry n;
            HashEntry e2 = this.table.get(slot);
            if (e2 != e1 && (ref2 = this.scanRef(e2, key2, pos)) != null) {
                this.creditSpace(size);
                Ref<T> ref3 = ref2;
                return ref3;
            }
            ref2 = new Ref<T>(key2, pos, size, v);
            ref2.hot = true;
            while (!this.table.compareAndSet(slot, e2, n = new HashEntry(DfsBlockCache.clean(e2), ref2))) {
                e2 = this.table.get(slot);
            }
            this.addToClock(ref2, 0);
        }
        finally {
            regionLock.unlock();
        }
        return ref2;
    }

    boolean contains(DfsStreamKey key2, long position) {
        return this.scan(this.table.get(this.slot(key2, position)), key2, position) != null;
    }

    <T> T get(DfsStreamKey key2, long position) {
        T val2 = this.scan(this.table.get(this.slot(key2, position)), key2, position);
        if (val2 == null) {
            this.statMiss.incrementAndGet();
        } else {
            this.statHit.incrementAndGet();
        }
        return val2;
    }

    private <T> T scan(HashEntry n, DfsStreamKey key2, long position) {
        Ref<T> r = this.scanRef(n, key2, position);
        return r != null ? (T)r.get() : null;
    }

    <T> Ref<T> getRef(DfsStreamKey key2) {
        Ref<T> r = this.scanRef(this.table.get(this.slot(key2, 0L)), key2, 0L);
        if (r != null) {
            this.statHit.incrementAndGet();
        } else {
            this.statMiss.incrementAndGet();
        }
        return r;
    }

    private <T> Ref<T> scanRef(HashEntry n, DfsStreamKey key2, long position) {
        while (n != null) {
            Ref r = n.ref;
            if (r.position == position && r.key.equals(key2)) {
                return r.get() != null ? r : null;
            }
            n = n.next;
        }
        return null;
    }

    private int slot(DfsStreamKey key2, long position) {
        return (this.hash(key2.hash, position) >>> 1) % this.tableSize;
    }

    private ReentrantLock lockFor(DfsStreamKey key2, long position) {
        return this.loadLocks[(this.hash(key2.hash, position) >>> 1) % this.loadLocks.length];
    }

    private static HashEntry clean(HashEntry top) {
        while (top != null && top.ref.next == null) {
            top = top.next;
        }
        if (top == null) {
            return null;
        }
        HashEntry n = DfsBlockCache.clean(top.next);
        return n == top.next ? top : new HashEntry(n, top.ref);
    }

    static {
        DfsBlockCache.reconfigure(new DfsBlockCacheConfig());
    }

    private static final class HashEntry {
        final HashEntry next;
        final Ref ref;

        HashEntry(HashEntry n, Ref r) {
            this.next = n;
            this.ref = r;
        }
    }

    static final class Ref<T> {
        final DfsStreamKey key;
        final long position;
        final int size;
        volatile T value;
        Ref next;
        volatile boolean hot;

        Ref(DfsStreamKey key2, long position, int size, T v) {
            this.key = key2;
            this.position = position;
            this.size = size;
            this.value = v;
        }

        T get() {
            T v = this.value;
            if (v != null) {
                this.hot = true;
            }
            return v;
        }

        boolean has() {
            return this.value != null;
        }
    }
}

