/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.OsmPrimitiveAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class ExportRelationToGpxAction
extends GpxExportAction
implements OsmPrimitiveAction {
    protected final EnumSet<Mode> mode;
    protected Collection<Relation> relations = Collections.emptySet();

    public ExportRelationToGpxAction() {
        this(EnumSet.of(Mode.FROM_FIRST_MEMBER, Mode.TO_FILE));
    }

    public ExportRelationToGpxAction(EnumSet<Mode> mode) {
        super(ExportRelationToGpxAction.name(mode), mode.contains((Object)Mode.TO_FILE) ? "exportgpx" : "dialogs/layerlist", ExportRelationToGpxAction.tooltip(mode), null, false, null, false);
        this.putValue("help", HelpUtil.ht("/Action/ExportRelationToGpx"));
        this.mode = mode;
    }

    private static String name(EnumSet<Mode> mode) {
        if (mode.contains((Object)Mode.TO_FILE)) {
            if (mode.contains((Object)Mode.FROM_FIRST_MEMBER)) {
                return I18n.tr("Export GPX file starting from first member", new Object[0]);
            }
            return I18n.tr("Export GPX file starting from last member", new Object[0]);
        }
        if (mode.contains((Object)Mode.FROM_FIRST_MEMBER)) {
            return I18n.tr("Convert to GPX layer starting from first member", new Object[0]);
        }
        return I18n.tr("Convert to GPX layer starting from last member", new Object[0]);
    }

    private static String tooltip(EnumSet<Mode> mode) {
        if (mode.contains((Object)Mode.FROM_FIRST_MEMBER)) {
            return I18n.tr("Flatten this relation to a single gpx track recursively, starting with the first member(s), successively continuing to the last.", new Object[0]);
        }
        return I18n.tr("Flatten this relation to a single gpx track recursively, starting with the last member(s), successively continuing to the first.", new Object[0]);
    }

    @Override
    protected Layer getLayer() {
        ArrayList<RelationMember> flat = new ArrayList<RelationMember>();
        ArrayList init = new ArrayList();
        this.relations.forEach(t -> init.add(new RelationMember("", (OsmPrimitive)t)));
        BidiIterableList l = new BidiIterableList(init);
        Stack<Iterator<RelationMember>> stack = new Stack<Iterator<RelationMember>>();
        stack.push(this.mode.contains((Object)Mode.FROM_FIRST_MEMBER) ? l.iterator() : l.reverseIterator());
        ArrayList<Relation> relsFound = new ArrayList<Relation>();
        block0: do {
            Iterator i;
            if (!(i = (Iterator)stack.peek()).hasNext()) {
                stack.pop();
            }
            while (i.hasNext()) {
                RelationMember m = (RelationMember)i.next();
                if (m.isRelation() && !m.getRelation().isIncomplete()) {
                    l = new BidiIterableList(m.getRelation().getMembers());
                    stack.push(this.mode.contains((Object)Mode.FROM_FIRST_MEMBER) ? l.iterator() : l.reverseIterator());
                    relsFound.add(m.getRelation());
                    continue block0;
                }
                if (!m.isWay()) continue;
                flat.add(m);
            }
        } while (!stack.isEmpty());
        GpxData gpxData = new GpxData();
        String layerName = " (GPX export)";
        long time = System.currentTimeMillis() - 86400000L;
        if (!flat.isEmpty()) {
            HashMap<String, Object> trkAttr = new HashMap<String, Object>();
            ArrayList<Collection<WayPoint>> trk = new ArrayList<Collection<WayPoint>>();
            ArrayList<WayPoint> trkseg = new ArrayList<WayPoint>();
            trk.add(trkseg);
            List<WayConnectionType> wct = new WayConnectionTypeCalculator().updateLinks(flat);
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            for (int i = 0; i < flat.size(); ++i) {
                if (wct.get((int)i).isOnewayLoopBackwardPart || wct.get((int)i).direction.isRoundabout()) continue;
                if (!wct.get((int)i).linkPrev && !trkseg.isEmpty()) {
                    gpxData.addTrack(new ImmutableGpxTrack((Collection<Collection<WayPoint>>)trk, (Map<String, Object>)trkAttr));
                    trkAttr.clear();
                    trk.clear();
                    trkseg.clear();
                    trk.add(trkseg);
                }
                if (trkAttr.isEmpty()) {
                    Relation r = Way.getParentRelations(Arrays.asList(((RelationMember)flat.get(i)).getWay())).stream().filter(relsFound::contains).findFirst().orElseGet(null);
                    if (r != null) {
                        trkAttr.put("name", r.getName() != null ? r.getName() : Long.valueOf(r.getId()));
                    }
                    GpxData.ensureUniqueName(trkAttr, names);
                }
                List<Node> ln = ((RelationMember)flat.get(i)).getWay().getNodes();
                if (wct.get((int)i).direction == WayConnectionType.Direction.BACKWARD) {
                    Collections.reverse(ln);
                }
                for (Node n : ln) {
                    trkseg.add(OsmDataLayer.nodeToWayPoint(n, time));
                    time += 1000L;
                }
            }
            gpxData.addTrack(new ImmutableGpxTrack((Collection<Collection<WayPoint>>)trk, (Map<String, Object>)trkAttr));
            String lprefix = this.relations.iterator().next().getName();
            if (lprefix == null || this.relations.size() > 1) {
                lprefix = I18n.tr("Selected Relations", new Object[0]);
            }
            layerName = lprefix + layerName;
        }
        return new GpxLayer(gpxData, layerName, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mode.contains((Object)Mode.TO_LAYER)) {
            MainApplication.getLayerManager().addLayer(this.getLayer());
        }
        if (this.mode.contains((Object)Mode.TO_FILE)) {
            super.actionPerformed(e);
        }
    }

    @Override
    public void setPrimitives(Collection<? extends OsmPrimitive> primitives) {
        this.relations = Collections.emptySet();
        if (primitives != null && !primitives.isEmpty()) {
            this.relations = new SubclassFilteredCollection<OsmPrimitive, Relation>(primitives, r -> r instanceof Relation && r.hasTag("type", Arrays.asList("route", "superroute")));
        }
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.relations.isEmpty());
    }

    private static final class BidiIterableList {
        private final List<RelationMember> l;

        private BidiIterableList(List<RelationMember> l) {
            this.l = l;
        }

        public Iterator<RelationMember> iterator() {
            return this.l.iterator();
        }

        public Iterator<RelationMember> reverseIterator() {
            final ListIterator<RelationMember> li = this.l.listIterator(this.l.size());
            return new Iterator<RelationMember>(){

                @Override
                public boolean hasNext() {
                    return li.hasPrevious();
                }

                @Override
                public RelationMember next() {
                    return (RelationMember)li.previous();
                }

                @Override
                public void remove() {
                    li.remove();
                }
            };
        }
    }

    public static enum Mode {
        FROM_FIRST_MEMBER,
        FROM_LAST_MEMBER,
        TO_LAYER,
        TO_FILE;

    }
}

