/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.search.InView;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSelector;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SearchAction
extends JosmAction
implements ParameterizedAction {
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 15;
    public static final int MAX_LENGTH_SEARCH_EXPRESSION_DISPLAY = 100;
    private static final String SEARCH_EXPRESSION = "searchExpression";
    private static final LinkedList<SearchSetting> searchHistory = new LinkedList();
    private static volatile SearchSetting lastSearch;

    public static Collection<SearchSetting> getSearchHistory() {
        return searchHistory;
    }

    public static void saveToHistory(SearchSetting s) {
        if (searchHistory.isEmpty() || !s.equals(searchHistory.getFirst())) {
            searchHistory.addFirst(new SearchSetting(s));
        } else if (searchHistory.contains(s)) {
            searchHistory.remove(s);
            searchHistory.addFirst(new SearchSetting(s));
        }
        int maxsize = Config.getPref().getInt("search.history-size", 15);
        while (searchHistory.size() > maxsize) {
            searchHistory.removeLast();
        }
        LinkedHashSet<String> savedHistory = new LinkedHashSet<String>(searchHistory.size());
        for (SearchSetting item : searchHistory) {
            savedHistory.add(item.writeToString());
        }
        Config.getPref().putList("search.history", new ArrayList<String>(savedHistory));
    }

    public static List<String> getSearchExpressionHistory() {
        ArrayList<String> ret = new ArrayList<String>(SearchAction.getSearchHistory().size());
        for (SearchSetting ss : SearchAction.getSearchHistory()) {
            ret.add(ss.text);
        }
        return ret;
    }

    public SearchAction() {
        super(I18n.tr("Search...", new Object[0]), "dialogs/search", I18n.tr("Search for objects.", new Object[0]), Shortcut.registerShortcut("system:find", I18n.tr("Search...", new Object[0]), 70, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/Search"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        SearchAction.search();
    }

    @Override
    public void actionPerformed(ActionEvent e, Map<String, Object> parameters) {
        if (parameters.get(SEARCH_EXPRESSION) == null) {
            this.actionPerformed(e);
        } else {
            SearchAction.searchWithoutHistory((SearchSetting)parameters.get(SEARCH_EXPRESSION));
        }
    }

    public static SearchSetting showSearchDialog(SearchSetting initialValues) {
        if (initialValues == null) {
            initialValues = new SearchSetting();
        }
        JLabel label = new JLabel(initialValues instanceof Filter ? I18n.tr("Filter string:", new Object[0]) : I18n.tr("Search string:", new Object[0]));
        final HistoryComboBox hcbSearchString = new HistoryComboBox();
        final String tooltip = I18n.tr("Enter the search expression", new Object[0]);
        hcbSearchString.setText(initialValues.text);
        hcbSearchString.setToolTipText(tooltip);
        List<String> searchExpressionHistory = SearchAction.getSearchExpressionHistory();
        Collections.reverse(searchExpressionHistory);
        hcbSearchString.setPossibleItems(searchExpressionHistory);
        hcbSearchString.setPreferredSize(new Dimension(40, hcbSearchString.getPreferredSize().height));
        label.setLabelFor(hcbSearchString);
        JRadioButton replace = new JRadioButton(I18n.tr("replace selection", new Object[0]), initialValues.mode == SearchMode.replace);
        JRadioButton add = new JRadioButton(I18n.tr("add to selection", new Object[0]), initialValues.mode == SearchMode.add);
        JRadioButton remove = new JRadioButton(I18n.tr("remove from selection", new Object[0]), initialValues.mode == SearchMode.remove);
        JRadioButton inSelection = new JRadioButton(I18n.tr("find in selection", new Object[0]), initialValues.mode == SearchMode.in_selection);
        ButtonGroup bg = new ButtonGroup();
        bg.add(replace);
        bg.add(add);
        bg.add(remove);
        bg.add(inSelection);
        final JCheckBox caseSensitive = new JCheckBox(I18n.tr("case sensitive", new Object[0]), initialValues.caseSensitive);
        JCheckBox allElements = new JCheckBox(I18n.tr("all objects", new Object[0]), initialValues.allElements);
        allElements.setToolTipText(I18n.tr("Also include incomplete and deleted objects in search.", new Object[0]));
        JCheckBox addOnToolbar = new JCheckBox(I18n.tr("add toolbar button", new Object[0]), false);
        JRadioButton standardSearch = new JRadioButton(I18n.tr("standard", new Object[0]), !initialValues.regexSearch && !initialValues.mapCSSSearch);
        final JRadioButton regexSearch = new JRadioButton(I18n.tr("regular expression", new Object[0]), initialValues.regexSearch);
        final JRadioButton mapCSSSearch = new JRadioButton(I18n.tr("MapCSS selector", new Object[0]), initialValues.mapCSSSearch);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(standardSearch);
        bg2.add(regexSearch);
        bg2.add(mapCSSSearch);
        JPanel selectionSettings = new JPanel(new GridBagLayout());
        selectionSettings.setBorder(BorderFactory.createTitledBorder(I18n.tr("Selection settings", new Object[0])));
        selectionSettings.add((Component)replace, GBC.eol().anchor(17).fill(2));
        selectionSettings.add((Component)add, GBC.eol());
        selectionSettings.add((Component)remove, GBC.eol());
        selectionSettings.add((Component)inSelection, GBC.eop());
        JPanel additionalSettings = new JPanel(new GridBagLayout());
        additionalSettings.setBorder(BorderFactory.createTitledBorder(I18n.tr("Additional settings", new Object[0])));
        additionalSettings.add((Component)caseSensitive, GBC.eol().anchor(17).fill(2));
        JPanel left = new JPanel(new GridBagLayout());
        left.add((Component)selectionSettings, GBC.eol().fill(1));
        left.add((Component)additionalSettings, GBC.eol().fill(1));
        if (ExpertToggleAction.isExpert()) {
            additionalSettings.add((Component)allElements, GBC.eol());
            additionalSettings.add((Component)addOnToolbar, GBC.eop());
            JPanel searchOptions = new JPanel(new GridBagLayout());
            searchOptions.setBorder(BorderFactory.createTitledBorder(I18n.tr("Search syntax", new Object[0])));
            searchOptions.add((Component)standardSearch, GBC.eol().anchor(17).fill(2));
            searchOptions.add((Component)regexSearch, GBC.eol());
            searchOptions.add((Component)mapCSSSearch, GBC.eol());
            left.add((Component)searchOptions, GBC.eol().fill(1));
        }
        JPanel right = SearchAction.buildHintsSection(hcbSearchString);
        JPanel top = new JPanel(new GridBagLayout());
        top.add((Component)label, GBC.std().insets(0, 0, 5, 0));
        top.add((Component)hcbSearchString, GBC.eol().fill(2));
        JTextField editorComponent = hcbSearchString.getEditorComponent();
        Document document = editorComponent.getDocument();
        document.addDocumentListener(new AbstractTextComponentValidator(editorComponent){

            @Override
            public void validate() {
                if (!this.isValid()) {
                    this.feedbackInvalid(I18n.tr("Invalid search expression", new Object[0]));
                } else {
                    this.feedbackValid(tooltip);
                }
            }

            @Override
            public boolean isValid() {
                try {
                    SearchSetting ss = new SearchSetting();
                    ss.text = hcbSearchString.getText();
                    ss.caseSensitive = caseSensitive.isSelected();
                    ss.regexSearch = regexSearch.isSelected();
                    ss.mapCSSSearch = mapCSSSearch.isSelected();
                    SearchCompiler.compile(ss);
                    return true;
                }
                catch (SearchParseError | MapCSSException e) {
                    return false;
                }
            }
        });
        TaggingPresetSelector selector = new TaggingPresetSelector(false, false);
        selector.setBorder(BorderFactory.createTitledBorder(I18n.tr("Search by preset", new Object[0])));
        selector.setDblClickListener(ev -> SearchAction.setPresetDblClickListener(selector, editorComponent));
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)top, GBC.eol().fill(2).insets(5, 5, 5, 0));
        p.add((Component)left, GBC.std().anchor(11).insets(5, 10, 10, 0).fill(3));
        p.add((Component)right, GBC.std().fill(1).insets(0, 10, 0, 0));
        p.add((Component)selector, GBC.eol().fill(1).insets(0, 10, 0, 0));
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, initialValues instanceof Filter ? I18n.tr("Filter", new Object[0]) : I18n.tr("Search", new Object[0]), new String[]{initialValues instanceof Filter ? I18n.tr("Submit filter", new Object[0]) : I18n.tr("Start Search", new Object[0]), I18n.tr("Cancel", new Object[0])}){

            @Override
            protected void buttonAction(int buttonIndex, ActionEvent evt) {
                if (buttonIndex == 0) {
                    try {
                        SearchSetting ss = new SearchSetting();
                        ss.text = hcbSearchString.getText();
                        ss.caseSensitive = caseSensitive.isSelected();
                        ss.regexSearch = regexSearch.isSelected();
                        ss.mapCSSSearch = mapCSSSearch.isSelected();
                        SearchCompiler.compile(ss);
                        super.buttonAction(buttonIndex, evt);
                    }
                    catch (SearchParseError | MapCSSException e) {
                        Logging.debug(e);
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Search expression is not valid: \n\n {0}", e.getMessage()), I18n.tr("Invalid search expression", new Object[0]), 0);
                    }
                } else {
                    super.buttonAction(buttonIndex, evt);
                }
            }
        };
        dialog.setButtonIcons("dialogs/search", "cancel");
        dialog.configureContextsensitiveHelp("/Action/Search", true);
        dialog.setContent(p);
        if (dialog.showDialog().getValue() != 1) {
            return null;
        }
        initialValues.text = hcbSearchString.getText();
        initialValues.caseSensitive = caseSensitive.isSelected();
        initialValues.allElements = allElements.isSelected();
        initialValues.regexSearch = regexSearch.isSelected();
        initialValues.mapCSSSearch = mapCSSSearch.isSelected();
        initialValues.mode = inSelection.isSelected() ? SearchMode.in_selection : (replace.isSelected() ? SearchMode.replace : (add.isSelected() ? SearchMode.add : SearchMode.remove));
        if (addOnToolbar.isSelected()) {
            ToolbarPreferences.ActionDefinition aDef = new ToolbarPreferences.ActionDefinition(MainApplication.getMenu().search);
            aDef.getParameters().put(SEARCH_EXPRESSION, initialValues);
            aDef.setName(Utils.shortenString(initialValues.text, 100));
            ToolbarPreferences.ActionParser actionParser = new ToolbarPreferences.ActionParser(null);
            String res = actionParser.saveAction(aDef);
            MainApplication.getToolbar().addCustomButton(res, -1, false);
        }
        return initialValues;
    }

    private static JPanel buildHintsSection(HistoryComboBox hcbSearchString) {
        JPanel hintPanel = new JPanel(new GridBagLayout());
        hintPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr("Search hints", new Object[0])));
        hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("basics", new Object[0])).addKeyword(I18n.tr("Baker Street", new Object[0]), null, I18n.tr("''Baker'' and ''Street'' in any key", new Object[0]), new String[0]).addKeyword(I18n.tr("\"Baker Street\"", new Object[0]), "\"\"", I18n.tr("''Baker Street'' in any key", new Object[0]), new String[0]).addKeyword("<i>key</i>:<i>valuefragment</i>", null, I18n.tr("''valuefragment'' anywhere in ''key''", new Object[0]), "name:str matches name=Bakerstreet").addKeyword("-<i>key</i>:<i>valuefragment</i>", null, I18n.tr("''valuefragment'' nowhere in ''key''", new Object[0]), new String[0]), GBC.eol());
        hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addKeyword("<i>key</i>=<i>value</i>", null, I18n.tr("''key'' with exactly ''value''", new Object[0]), new String[0]).addKeyword("<i>key</i>=*", null, I18n.tr("''key'' with any value", new Object[0]), new String[0]).addKeyword("*=<i>value</i>", null, I18n.tr("''value'' in any key", new Object[0]), new String[0]).addKeyword("<i>key</i>=", null, I18n.tr("matches if ''key'' exists", new Object[0]), new String[0]).addKeyword("<i>key</i>><i>value</i>", null, I18n.tr("matches if ''key'' is greater than ''value'' (analogously, less than)", new Object[0]), new String[0]).addKeyword("\"key\"=\"value\"", "\"\"=\"\"", I18n.tr("to quote operators.<br>Within quoted strings the <b>\"</b> and <b>\\</b> characters need to be escaped by a preceding <b>\\</b> (e.g. <b>\\\"</b> and <b>\\\\</b>).", new Object[0]), "\"addr:street\""), GBC.eol().anchor(10));
        hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("combinators", new Object[0])).addKeyword("<i>expr</i> <i>expr</i>", null, I18n.tr("logical and (both expressions have to be satisfied)", new Object[0]), new String[0]).addKeyword("<i>expr</i> | <i>expr</i>", "| ", I18n.tr("logical or (at least one expression has to be satisfied)", new Object[0]), new String[0]).addKeyword("<i>expr</i> OR <i>expr</i>", "OR ", I18n.tr("logical or (at least one expression has to be satisfied)", new Object[0]), new String[0]).addKeyword("-<i>expr</i>", null, I18n.tr("logical not", new Object[0]), new String[0]).addKeyword("(<i>expr</i>)", "()", I18n.tr("use parenthesis to group expressions", new Object[0]), new String[0]), GBC.eol());
        if (ExpertToggleAction.isExpert()) {
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("objects", new Object[0])).addKeyword("type:node", "type:node ", I18n.tr("all nodes", new Object[0]), new String[0]).addKeyword("type:way", "type:way ", I18n.tr("all ways", new Object[0]), new String[0]).addKeyword("type:relation", "type:relation ", I18n.tr("all relations", new Object[0]), new String[0]).addKeyword("closed", "closed ", I18n.tr("all closed ways", new Object[0]), new String[0]).addKeyword("untagged", "untagged ", I18n.tr("object without useful tags", new Object[0]), new String[0]), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addKeyword("preset:\"Annotation/Address\"", "preset:\"Annotation/Address\"", I18n.tr("all objects that use the address preset", new Object[0]), new String[0]).addKeyword("preset:\"Geography/Nature/*\"", "preset:\"Geography/Nature/*\"", I18n.tr("all objects that use any preset under the Geography/Nature group", new Object[0]), new String[0]), GBC.eol().anchor(10));
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("metadata", new Object[0])).addKeyword("user:", "user:", I18n.tr("objects changed by user", "user:anonymous"), new String[0]).addKeyword("id:", "id:", I18n.tr("objects with given ID", new Object[0]), "id:0 (new objects)").addKeyword("version:", "version:", I18n.tr("objects with given version", new Object[0]), "version:0 (objects without an assigned version)").addKeyword("changeset:", "changeset:", I18n.tr("objects with given changeset ID", new Object[0]), "changeset:0 (objects without an assigned changeset)").addKeyword("timestamp:", "timestamp:", I18n.tr("objects with last modification timestamp within range", new Object[0]), "timestamp:2012/", "timestamp:2008/2011-02-04T12"), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("properties", new Object[0])).addKeyword("nodes:<i>20-</i>", "nodes:", I18n.tr("ways with at least 20 nodes, or relations containing at least 20 nodes", new Object[0]), new String[0]).addKeyword("ways:<i>3-</i>", "ways:", I18n.tr("nodes with at least 3 referring ways, or relations containing at least 3 ways", new Object[0]), new String[0]).addKeyword("tags:<i>5-10</i>", "tags:", I18n.tr("objects having 5 to 10 tags", new Object[0]), new String[0]).addKeyword("role:", "role:", I18n.tr("objects with given role in a relation", new Object[0]), new String[0]).addKeyword("areasize:<i>-100</i>", "areasize:", I18n.tr("closed ways with an area of 100 m\u00b2", new Object[0]), new String[0]).addKeyword("waylength:<i>200-</i>", "waylength:", I18n.tr("ways with a length of 200 m or more", new Object[0]), new String[0]), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("state", new Object[0])).addKeyword("modified", "modified ", I18n.tr("all modified objects", new Object[0]), new String[0]).addKeyword("new", "new ", I18n.tr("all new objects", new Object[0]), new String[0]).addKeyword("selected", "selected ", I18n.tr("all selected objects", new Object[0]), new String[0]).addKeyword("incomplete", "incomplete ", I18n.tr("all incomplete objects", new Object[0]), new String[0]).addKeyword("deleted", "deleted ", I18n.tr("all deleted objects (checkbox <b>{0}</b> must be enabled)", I18n.tr("all objects", new Object[0])), new String[0]), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("related objects", new Object[0])).addKeyword("child <i>expr</i>", "child ", I18n.tr("all children of objects matching the expression", new Object[0]), "child building").addKeyword("parent <i>expr</i>", "parent ", I18n.tr("all parents of objects matching the expression", new Object[0]), "parent bus_stop").addKeyword("hasRole:<i>stop</i>", "hasRole:", I18n.tr("relation containing a member of role <i>stop</i>", new Object[0]), new String[0]).addKeyword("role:<i>stop</i>", "role:", I18n.tr("objects being part of a relation as role <i>stop</i>", new Object[0]), new String[0]).addKeyword("nth:<i>7</i>", "nth:", I18n.tr("n-th member of relation and/or n-th node of way", new Object[0]), "nth:5 (child type:relation)", "nth:-1").addKeyword("nth%:<i>7</i>", "nth%:", I18n.tr("every n-th member of relation and/or every n-th node of way", new Object[0]), "nth%:100 (child waterway)"), GBC.eol());
            hintPanel.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("view", new Object[0])).addKeyword("inview", "inview ", I18n.tr("objects in current view", new Object[0]), new String[0]).addKeyword("allinview", "allinview ", I18n.tr("objects (and all its way nodes / relation members) in current view", new Object[0]), new String[0]).addKeyword("indownloadedarea", "indownloadedarea ", I18n.tr("objects in downloaded area", new Object[0]), new String[0]).addKeyword("allindownloadedarea", "allindownloadedarea ", I18n.tr("objects (and all its way nodes / relation members) in downloaded area", new Object[0]), new String[0]), GBC.eol());
        }
        return hintPanel;
    }

    public static void search() {
        SearchSetting se = SearchAction.showSearchDialog(lastSearch);
        if (se != null) {
            SearchAction.searchWithHistory(se);
        }
    }

    public static void searchWithHistory(SearchSetting s) {
        SearchAction.saveToHistory(s);
        lastSearch = new SearchSetting(s);
        SearchAction.search(s);
    }

    public static void searchWithoutHistory(SearchSetting s) {
        lastSearch = new SearchSetting(s);
        SearchAction.search(s);
    }

    public static void search(String search, SearchMode mode) {
        SearchSetting searchSetting = new SearchSetting();
        searchSetting.text = search;
        searchSetting.mode = mode;
        SearchAction.search(searchSetting);
    }

    static void search(SearchSetting s) {
        SearchTask.newSearchTask(s, new SelectSearchReceiver()).run();
    }

    public static Collection<OsmPrimitive> searchAndReturn(String search, SearchMode mode) {
        SearchSetting searchSetting = new SearchSetting();
        searchSetting.text = search;
        searchSetting.mode = mode;
        CapturingSearchReceiver receiver = new CapturingSearchReceiver();
        SearchTask.newSearchTask(searchSetting, receiver).run();
        return receiver.result;
    }

    private static void setPresetDblClickListener(TaggingPresetSelector selector, JTextComponent searchEditor) {
        TaggingPreset selectedPreset = selector.getSelectedPresetAndUpdateClassification();
        if (selectedPreset == null) {
            return;
        }
        searchEditor.requestFocusInWindow();
        SwingUtilities.invokeLater(() -> {
            int textOffset = searchEditor.getCaretPosition();
            String presetSearchQuery = " preset:\"" + selectedPreset.getRawName() + "\"";
            try {
                searchEditor.getDocument().insertString(textOffset, presetSearchQuery, null);
            }
            catch (BadLocationException e1) {
                throw new JosmRuntimeException(e1.getMessage(), e1);
            }
        });
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null);
    }

    @Override
    public List<ActionParameter<?>> getActionParameters() {
        return Collections.singletonList(new SearchSettingsActionParameter(SEARCH_EXPRESSION));
    }

    static {
        SearchCompiler.addMatchFactory(new SearchCompiler.SimpleMatchFactory(){

            @Override
            public Collection<String> getKeywords() {
                return Arrays.asList("inview", "allinview");
            }

            @Override
            public SearchCompiler.Match get(String keyword, boolean caseSensitive, boolean regexSearch, PushbackTokenizer tokenizer) throws SearchParseError {
                switch (keyword) {
                    case "inview": {
                        return new InView(false);
                    }
                    case "allinview": {
                        return new InView(true);
                    }
                }
                throw new IllegalStateException("Not expecting keyword " + keyword);
            }
        });
        for (String s : Config.getPref().getList("search.history", Collections.emptyList())) {
            SearchSetting ss = SearchSetting.readFromString(s);
            if (ss == null) continue;
            searchHistory.add(ss);
        }
    }

    public static class SearchSettingsActionParameter
    extends ActionParameter<SearchSetting> {
        public SearchSettingsActionParameter(String name) {
            super(name);
        }

        @Override
        public Class<SearchSetting> getType() {
            return SearchSetting.class;
        }

        @Override
        public SearchSetting readFromString(String s) {
            return SearchSetting.readFromString(s);
        }

        @Override
        public String writeToString(SearchSetting value) {
            if (value == null) {
                return "";
            }
            return value.writeToString();
        }
    }

    static final class SearchTask
    extends PleaseWaitRunnable {
        private final DataSet ds;
        private final SearchSetting setting;
        private final Collection<OsmPrimitive> selection;
        private final Predicate<OsmPrimitive> predicate;
        private boolean canceled;
        private int foundMatches;
        private final SearchReceiver resultReceiver;

        private SearchTask(DataSet ds, SearchSetting setting, Collection<OsmPrimitive> selection, Predicate<OsmPrimitive> predicate, SearchReceiver resultReceiver) {
            super(I18n.tr("Searching", new Object[0]));
            this.ds = ds;
            this.setting = setting;
            this.selection = selection;
            this.predicate = predicate;
            this.resultReceiver = resultReceiver;
        }

        static SearchTask newSearchTask(SearchSetting setting, SearchReceiver resultReceiver) {
            DataSet ds = MainApplication.getLayerManager().getEditDataSet();
            return SearchTask.newSearchTask(setting, ds, resultReceiver);
        }

        private static SearchTask newSearchTask(SearchSetting setting, DataSet ds, SearchReceiver resultReceiver) {
            HashSet<OsmPrimitive> selection = new HashSet<OsmPrimitive>(ds.getAllSelected());
            return new SearchTask(ds, setting, selection, ds::isSelected, resultReceiver);
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void realRun() {
            try {
                this.foundMatches = 0;
                SearchCompiler.Match matcher = SearchCompiler.compile(this.setting);
                if (this.setting.mode == SearchMode.replace) {
                    this.selection.clear();
                } else if (this.setting.mode == SearchMode.in_selection) {
                    this.foundMatches = this.selection.size();
                }
                Collection<OsmPrimitive> all = this.setting.allElements ? this.ds.allPrimitives() : this.ds.getPrimitives(OsmPrimitive::isSelectable);
                ProgressMonitor subMonitor = this.getProgressMonitor().createSubTaskMonitor(all.size(), false);
                subMonitor.beginTask(I18n.trn("Searching in {0} object", "Searching in {0} objects", all.size(), all.size()));
                for (OsmPrimitive osm : all) {
                    if (this.canceled) {
                        return;
                    }
                    if (this.setting.mode == SearchMode.replace) {
                        if (matcher.match(osm)) {
                            this.selection.add(osm);
                            ++this.foundMatches;
                        }
                    } else if (this.setting.mode == SearchMode.add && !this.predicate.test(osm) && matcher.match(osm)) {
                        this.selection.add(osm);
                        ++this.foundMatches;
                    } else if (this.setting.mode == SearchMode.remove && this.predicate.test(osm) && matcher.match(osm)) {
                        this.selection.remove(osm);
                        ++this.foundMatches;
                    } else if (this.setting.mode == SearchMode.in_selection && this.predicate.test(osm) && !matcher.match(osm)) {
                        this.selection.remove(osm);
                        --this.foundMatches;
                    }
                    subMonitor.worked(1);
                }
                subMonitor.finishTask();
            }
            catch (SearchParseError e) {
                Logging.debug(e);
                JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Error", new Object[0]), 0);
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            this.resultReceiver.receiveSearchResult(this.ds, this.selection, this.foundMatches, this.setting, this.getProgressMonitor().getWindowParent());
        }
    }

    private static final class CapturingSearchReceiver
    implements SearchReceiver {
        private Collection<OsmPrimitive> result;

        private CapturingSearchReceiver() {
        }

        @Override
        public void receiveSearchResult(DataSet ds, Collection<OsmPrimitive> result, int foundMatches, SearchSetting setting, Component parent) {
            this.result = result;
        }
    }

    private static class SelectSearchReceiver
    implements SearchReceiver {
        private SelectSearchReceiver() {
        }

        @Override
        public void receiveSearchResult(DataSet ds, Collection<OsmPrimitive> result, int foundMatches, SearchSetting setting, Component parent) {
            ds.setSelected(result);
            MapFrame map = MainApplication.getMap();
            if (foundMatches == 0) {
                String text = Utils.shortenString(setting.text, 100);
                String msg = setting.mode == SearchMode.replace ? I18n.tr("No match found for ''{0}''", text) : (setting.mode == SearchMode.add ? I18n.tr("Nothing added to selection by searching for ''{0}''", text) : (setting.mode == SearchMode.remove ? I18n.tr("Nothing removed from selection by searching for ''{0}''", text) : (setting.mode == SearchMode.in_selection ? I18n.tr("Nothing found in selection by searching for ''{0}''", text) : null)));
                if (map != null) {
                    map.statusLine.setHelpText(msg);
                }
                if (!GraphicsEnvironment.isHeadless()) {
                    new Notification(msg).show();
                }
            } else {
                map.statusLine.setHelpText(I18n.tr("Found {0} matches", foundMatches));
            }
        }
    }

    @FunctionalInterface
    static interface SearchReceiver {
        public void receiveSearchResult(DataSet var1, Collection<OsmPrimitive> var2, int var3, SearchSetting var4, Component var5);
    }

    private static class SearchKeywordRow
    extends JPanel {
        private final HistoryComboBox hcb;

        SearchKeywordRow(HistoryComboBox hcb) {
            super(new FlowLayout(0));
            this.hcb = hcb;
        }

        public SearchKeywordRow addTitle(String title) {
            this.add(new JLabel(I18n.tr("{0}: ", title)));
            return this;
        }

        public SearchKeywordRow addKeyword(String displayText, final String insertText, String description, String ... examples) {
            JLabel label = new JLabel("<html><style>td{border:1px solid gray; font-weight:normal;}</style><table><tr><td>" + displayText + "</td></tr></table></html>");
            this.add(label);
            if (description != null || examples.length > 0) {
                label.setToolTipText("<html>" + description + (examples.length > 0 ? Utils.joinAsHtmlUnorderedList(Arrays.asList(examples)) : "") + "</html>");
            }
            if (insertText != null) {
                label.setCursor(Cursor.getPredefinedCursor(12));
                label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        JTextField tf = hcb.getEditorComponent();
                        if (!tf.hasFocus()) {
                            tf.requestFocusInWindow();
                        }
                        SwingUtilities.invokeLater(() -> {
                            try {
                                tf.getDocument().insertString(tf.getCaretPosition(), ' ' + insertText, null);
                            }
                            catch (BadLocationException ex) {
                                throw new JosmRuntimeException(ex.getMessage(), ex);
                            }
                        });
                    }
                });
            }
            return this;
        }
    }
}

